/*
 * Decompiled with CFR 0.152.
 */
package os;

import java.util.Vector;
import os.OSProcessDone;
import os.OSProcessExecProcess;
import os.OSProcessLoadProcess;
import os.OSProcessRelinquishControl;
import os.OSProcessWaitForProcess;
import os.Shared;
import util.KeyValue;

public abstract class OSProcess {
    int id = -1;
    int parentId = -1;
    int waitingFor = -1;
    boolean initialized = false;
    Object o = null;
    int exitStatus = 0;
    String[] args = new String[1];
    Shared shared = null;

    public OSProcess() {
        this.args[0] = "";
    }

    public void done() {
    }

    KeyValue findKeyValuePair(String key, Vector pairs) {
        int i = 0;
        boolean done = false;
        KeyValue rc = null;
        KeyValue thisPair = null;
        int length = pairs.size();
        while (i < length && !done) {
            thisPair = (KeyValue)pairs.elementAt(i);
            if (thisPair.getKey().toLowerCase().equalsIgnoreCase(key)) {
                done = true;
                rc = thisPair;
                continue;
            }
            ++i;
        }
        return rc;
    }

    public String[] getArgs() {
        return this.args;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    public int getId() {
        return this.id;
    }

    public Object getObject() {
        return this.o;
    }

    public int getParentId() {
        return this.parentId;
    }

    public Shared getShared() {
        return this.shared;
    }

    public int getWaitingFor() {
        return this.waitingFor;
    }

    public void initialize() {
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isWaitingFor() {
        return this.waitingFor != -1;
    }

    public void registerObject(String name, Object o) {
        KeyValue kv = null;
        kv = new KeyValue(name, o);
        this.shared.addElement(kv);
    }

    public Object requestObject(String name) {
        KeyValue kv = null;
        Object o = null;
        kv = this.shared.findKeyValuePair(name, this.shared);
        if (kv != null) {
            o = kv.getObject();
        }
        return o;
    }

    public abstract void run() throws OSProcessRelinquishControl, OSProcessDone, OSProcessLoadProcess, OSProcessExecProcess, OSProcessWaitForProcess;

    public void setArgs(String args) {
        Vector<String> vector = null;
        int state = 0;
        StringBuffer arg = null;
        int i = 0;
        while (i < args.length()) {
            switch (state) {
                case 0: {
                    if (args.charAt(i) == ' ') {
                        state = 1;
                        break;
                    }
                    if (args.charAt(i) == '\"') {
                        if (arg != null && arg.length() != 0) {
                            if (vector == null) {
                                vector = new Vector();
                            }
                            vector.addElement(arg.toString());
                            arg = new StringBuffer();
                        }
                        ++i;
                        state = 2;
                        break;
                    }
                    if (arg == null) {
                        arg = new StringBuffer();
                    }
                    arg.append(args.charAt(i));
                    ++i;
                    break;
                }
                case 1: {
                    if (arg != null && arg.length() != 0) {
                        if (vector == null) {
                            vector = new Vector();
                        }
                        vector.addElement(arg.toString());
                        arg = new StringBuffer();
                    }
                    ++i;
                    state = 0;
                    break;
                }
                case 2: {
                    if (args.charAt(i) == '\"') {
                        state = 3;
                        break;
                    }
                    if (arg == null) {
                        arg = new StringBuffer();
                    }
                    arg.append(args.charAt(i));
                    ++i;
                    break;
                }
                case 3: {
                    if (arg != null && arg.length() != 0) {
                        if (vector == null) {
                            vector = new Vector();
                        }
                        vector.addElement(arg.toString());
                        arg = new StringBuffer();
                    }
                    ++i;
                    state = 0;
                    break;
                }
            }
        }
        if (arg != null && arg.length() > 0) {
            if (vector == null) {
                vector = new Vector<String>();
            }
            vector.addElement(arg.toString());
        }
        this.args = new String[vector.size()];
        vector.copyInto(this.args);
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    public void setExitStatus(int exitStatus) {
        this.exitStatus = exitStatus;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public void setObject(Object o) {
        this.o = o;
    }

    public void setParentId(int parentId) {
        this.parentId = parentId;
    }

    public void setShared(Shared shared) {
        this.shared = shared;
    }

    public void setWaitingFor(int waitingFor) {
        this.waitingFor = waitingFor;
    }

    public String toString() {
        StringBuffer sb = null;
        sb = new StringBuffer();
        sb.append(this.id).append("        ").append(this.parentId).append("        ").append(this.waitingFor).append("        ").append(this.initialized);
        return sb.toString();
    }
}

