/*
 * Decompiled with CFR 0.152.
 */
package os;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class OSProcessLoader
extends ClassLoader {
    private Hashtable types = new Hashtable();
    private String basePath;

    public OSProcessLoader(String basePath) {
        this.basePath = basePath;
    }

    private byte[] getTypeFromBasePath(String className) {
        FileInputStream in = null;
        String fileName = String.valueOf(this.basePath) + "/" + className + ".class";
        try {
            in = new FileInputStream(fileName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int c = ((InputStream)in).read();
            while (c != -1) {
                out.write(c);
                c = ((InputStream)in).read();
            }
        }
        catch (IOException e) {
            System.out.println("SCL: Error reading bytes of:" + className);
            e.printStackTrace();
            return null;
        }
        return out.toByteArray();
    }

    public synchronized Class loadClass(String className, boolean resolveIt) throws ClassNotFoundException {
        Class<?> result = (Class<?>)this.types.get(className);
        if (result != null) {
            return result;
        }
        try {
            result = super.findSystemClass(className);
            return result;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (className.startsWith("java.")) {
                throw new ClassNotFoundException();
            }
            byte[] classData = this.getTypeFromBasePath(className);
            if (classData == null) {
                System.out.println("GCL - Can't load class: " + className);
                throw new ClassNotFoundException();
            }
            result = this.defineClass(className, classData, 0, classData.length);
            if (result == null) {
                System.out.println("GCL - Class format error: " + className);
                throw new ClassFormatError();
            }
            if (resolveIt) {
                this.resolveClass(result);
            }
            this.types.put(className, result);
            return result;
        }
    }
}

