/*
 * Decompiled with CFR 0.152.
 */
package mstar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Stack;
import java.util.Vector;
import mstar.Exit;
import mstar.PathComponent;
import mstar.Room;

public class MudMap
extends Vector
implements Serializable {
    int id = 0;
    String mapFilename = "tween.map";
    Room currentRoom = null;
    Room previousRoom = null;
    Room home = null;

    public MudMap() {
    }

    public MudMap(Room room) {
        this.add(room);
    }

    public void WriteMap() {
        FileOutputStream o = null;
        OutputStreamWriter w = null;
        try {
            o = new FileOutputStream(this.getMapFilename());
            w = new OutputStreamWriter(o);
            w.write(this.toString());
            w.close();
        }
        catch (IOException ie) {
            System.out.println(ie.toString());
        }
    }

    public void WriteMapAsObjects() {
        try {
            Object[] r = new Room[this.size()];
            this.copyInto(r);
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream("tween.dat"));
            out.writeObject(r);
            out.close();
        }
        catch (IOException ioe) {
            System.out.println(ioe.toString());
        }
    }

    public synchronized void add(Room room) {
        room.setId(this.id);
        ++this.id;
        super.addElement(room);
        this.WriteMap();
        this.WriteMapAsObjects();
    }

    public void clearRoomsVisited() {
        int length = this.size();
        int i = 0;
        while (i < length) {
            ((Room)this.elementAt(i)).setVisited(false);
            ++i;
        }
    }

    public void clearVisitedExits() {
        int length = this.size();
        int i = 0;
        while (i < length) {
            Room aRoom = (Room)this.elementAt(i);
            aRoom.clearVisitedExits();
            ++i;
        }
    }

    public synchronized void fastAdd(Room room) {
        room.setId(this.id);
        ++this.id;
        super.addElement(room);
    }

    Exit findNextExit(Room r) {
        boolean done = false;
        int i = 0;
        Exit rc = null;
        Exit[] g = null;
        g = r.getGoodExits();
        if (g != null) {
            while (i < g.length && !done) {
                if (g[i].isConfusing() || ((Room)this.elementAt(g[i].getToRoom())).getVisited()) {
                    ++i;
                    continue;
                }
                rc = g[i];
                done = true;
            }
        }
        return rc;
    }

    public Vector findObject(String object) {
        Vector<Room> theRooms = null;
        Room r = null;
        int length = this.size();
        int i = 0;
        while (i < length) {
            r = (Room)this.elementAt(i);
            if (r.containsObject(object)) {
                if (theRooms == null) {
                    theRooms = new Vector<Room>();
                }
                theRooms.addElement(r);
            }
            ++i;
        }
        return theRooms;
    }

    public Stack findPath(int start, int destination) {
        int depth = 0;
        boolean extended = true;
        boolean found = false;
        PathComponent[] path = null;
        Exit[] goodExits = null;
        Stack<PathComponent> stack = null;
        path = new PathComponent[this.size()];
        int i = 0;
        while (i < this.size()) {
            path[i] = new PathComponent();
            ++i;
        }
        path[destination].setToRoom(destination);
        path[destination].setDepth(0);
        while (extended && !found && depth < this.size()) {
            extended = false;
            i = 0;
            while (i < this.size() && !found) {
                if (path[i].getDepth() < 0 && (goodExits = this.getRoom(i).getGoodExits()) != null) {
                    int j = 0;
                    while (j < goodExits.length && !found) {
                        if (goodExits[j].getToRoom() != i && path[goodExits[j].getToRoom()].getDepth() == depth) {
                            extended = true;
                            path[i].setDirection(goodExits[j].getDirection());
                            path[i].setToRoom(goodExits[j].getToRoom());
                            path[i].setFromRoom(goodExits[j].getFromRoom());
                            path[i].setDepth(path[goodExits[j].getToRoom()].getDepth() + 1);
                            if (i == start) {
                                found = true;
                            }
                        }
                        ++j;
                    }
                }
                goodExits = null;
                ++i;
            }
            ++depth;
        }
        if (found) {
            stack = new Stack<PathComponent>();
            i = start;
            while (i != destination) {
                stack.push(path[i]);
                i = path[i].getToRoom();
            }
        }
        return stack;
    }

    public Stack findPath(Room start, Room destination) {
        return this.findPath(start.getId(), destination.getId());
    }

    public Stack findPathToRoom(int start, int destination) {
        Stack stack = null;
        Stack directions = null;
        Exit home = null;
        this.clearRoomsVisited();
        stack = this.findPath(start, destination);
        if (stack == null || stack != null && stack.empty()) {
            this.clearRoomsVisited();
            stack = this.findPath(0, destination);
            if (!(stack == null || stack != null && stack.empty())) {
                home = new Exit();
                directions = new Stack();
                while (!stack.empty()) {
                    directions.push(stack.pop());
                }
                home.setDirection("home");
                home.setToRoom(((Exit)directions.peek()).getFromRoom());
                directions.push(home);
            }
        } else {
            directions = new Stack();
            while (!stack.empty()) {
                directions.push(stack.pop());
            }
        }
        return directions;
    }

    public Stack findPathToRoom(Room start, Room destination) {
        return this.findPathToRoom(start.getId(), destination.getId());
    }

    public Room getCurrentRoom() {
        return this.currentRoom;
    }

    public Room getHome() {
        return this.home;
    }

    public synchronized int getId() {
        return this.id;
    }

    public String getMapFilename() {
        return this.mapFilename;
    }

    public Room getPreviousRoom() {
        return this.previousRoom;
    }

    public Room getRoom(int id) {
        int i = 0;
        int length = this.size();
        boolean done = false;
        Room room = null;
        while (!done && i < length) {
            if (((Room)this.elementAt(i)).getId() == id) {
                room = (Room)this.elementAt(i);
                done = true;
                continue;
            }
            ++i;
        }
        return room;
    }

    public Room getRoom(String name) {
        int i = 0;
        int length = this.size();
        boolean done = false;
        Room room = null;
        while (!done && i < length) {
            if (((Room)this.elementAt(i)).getName().toLowerCase().equals(name.toLowerCase())) {
                room = (Room)this.elementAt(i);
                done = true;
                continue;
            }
            ++i;
        }
        return room;
    }

    public Room getRoom(Room r) {
        int i = 0;
        int length = this.size();
        boolean done = false;
        Room room = null;
        while (!done && i < length) {
            if (r.equals((Room)this.elementAt(i))) {
                room = (Room)this.elementAt(i);
                done = true;
                continue;
            }
            ++i;
        }
        return room;
    }

    public Room getRoomWithUnexploredExits() {
        int i = 0;
        int length = this.size();
        boolean done = false;
        Room room = null;
        while (!done && i < length) {
            if (((Room)this.elementAt(i)).hasUnexploredExits()) {
                room = (Room)this.elementAt(i);
                done = true;
                continue;
            }
            ++i;
        }
        return room;
    }

    public Room getRoomWithUnexploredExits(int after) {
        int i = after + 1;
        int length = this.size();
        boolean done = false;
        Room room = null;
        while (!done && i < length) {
            if (((Room)this.elementAt(i)).hasUnexploredExits()) {
                room = (Room)this.elementAt(i);
                done = true;
                continue;
            }
            ++i;
        }
        return room;
    }

    public static MudMap loadMap() {
        Room[] mapAry = null;
        int highest = -1;
        MudMap map = null;
        try {
            File f = new File("tween.dat");
            if (f.exists()) {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream("tween.dat"));
                mapAry = (Room[])in.readObject();
                in.close();
                map = new MudMap();
                int j = 0;
                while (j < mapAry.length) {
                    if (highest < mapAry[j].getId()) {
                        highest = mapAry[j].getId();
                    }
                    map.fastAdd(mapAry[j]);
                    ++j;
                }
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe.toString());
        }
        catch (ClassNotFoundException cnf) {
            System.out.println(cnf.toString());
        }
        return map;
    }

    public String makeDirections(int start, Stack s) {
        StringBuffer directions = new StringBuffer();
        Exit theExit = null;
        if (s != null && !s.empty()) {
            directions.append("Starting from ").append(this.getRoom(start).getName()).append("(").append(start).append(")");
            int i = s.size() - 1;
            while (i >= 0) {
                theExit = (Exit)s.elementAt(i);
                directions.append(" ").append(theExit.getDirection()).append("[").append(theExit.getFromRoom()).append(", ").append(theExit.getToRoom()).append("]");
                --i;
            }
        }
        return directions.toString();
    }

    public void readMap() {
    }

    public boolean roomExists(int id) {
        int i = 0;
        int length = this.size();
        boolean done = false;
        Room room = null;
        boolean rc = false;
        while (!done && i < length) {
            room = (Room)this.elementAt(i);
            if (room.getId() == id) {
                rc = true;
                done = true;
                continue;
            }
            ++i;
        }
        return rc;
    }

    public boolean roomExists(String name) {
        int i = 0;
        int length = this.size();
        boolean done = false;
        Room room = null;
        boolean rc = false;
        while (!done && i < length) {
            if (((Room)this.elementAt(i)).getName().equals(name)) {
                room = (Room)this.elementAt(i);
                rc = true;
                done = true;
                continue;
            }
            ++i;
        }
        return rc;
    }

    public boolean roomExists(Room theRoom) {
        int i = 0;
        int length = this.size();
        boolean done = false;
        Room room = null;
        boolean rc = false;
        while (!done && i < length) {
            room = (Room)this.elementAt(i);
            if (theRoom.equals(room)) {
                done = true;
                rc = true;
                continue;
            }
            ++i;
        }
        return rc;
    }

    public void setCurrentRoom(Room currentRoom) {
        this.currentRoom = currentRoom;
    }

    public void setFallbackExits(String[] exits) {
        int length = this.size();
        int i = 0;
        while (i < length) {
            ((Room)this.elementAt(i)).setFallbackExits(exits);
            ++i;
        }
    }

    public void setHome(Room home) {
        this.home = home;
    }

    public void setMapFilename(String mapFilename) {
        this.mapFilename = mapFilename;
    }

    public void setPreviousRoom(Room previousRoom) {
        this.previousRoom = previousRoom;
    }

    public void setUseFallbackExits(boolean t) {
        int length = this.size();
        int i = 0;
        while (i < length) {
            ((Room)this.elementAt(i)).setUseFallbackExits(t);
            ++i;
        }
    }

    public void setUsePossibleExits(boolean t) {
        int length = this.size();
        int i = 0;
        while (i < length) {
            ((Room)this.elementAt(i)).setUsePossibleExits(t);
            ++i;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.size()) {
            Room aRoom = (Room)this.elementAt(i);
            sb.append(aRoom.toMap());
            ++i;
        }
        return sb.toString();
    }
}

