/*
 * Decompiled with CFR 0.152.
 */
package mstar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Vector;
import mstar.MudPlayer;

public class PlayerMap
extends Vector
implements Serializable {
    int id = 0;
    String mapFilename = "tween.players.map";

    public PlayerMap() {
    }

    public PlayerMap(MudPlayer player) {
        this.add(player);
    }

    public void WriteMap() {
        FileOutputStream o = null;
        OutputStreamWriter w = null;
        try {
            o = new FileOutputStream(this.getMapFilename());
            w = new OutputStreamWriter(o);
            w.write(this.toString());
            w.close();
        }
        catch (IOException ie) {
            System.out.println(ie.toString());
        }
    }

    public void WriteMapAsObjects() {
        try {
            Object[] p = new MudPlayer[this.size()];
            this.copyInto(p);
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream("tween.players.dat"));
            out.writeObject(p);
            out.close();
        }
        catch (IOException ioe) {
            System.out.println(ioe.toString());
        }
    }

    public synchronized void add(MudPlayer player) {
        if (this.getMudPlayer(player) == null) {
            player.setId(this.id);
            ++this.id;
            super.addElement(player);
            this.WriteMap();
            this.WriteMapAsObjects();
        }
    }

    public synchronized void fastAdd(MudPlayer player) {
        player.setId(this.id);
        ++this.id;
        super.addElement(player);
    }

    public synchronized int getId() {
        return this.id;
    }

    public String getMapFilename() {
        return this.mapFilename;
    }

    public MudPlayer getMudPlayer(int id) {
        int i = 0;
        int length = this.size();
        boolean done = false;
        MudPlayer player = null;
        while (!done && i < length) {
            if (((MudPlayer)this.elementAt(i)).getId() == id) {
                player = (MudPlayer)this.elementAt(i);
                done = true;
                continue;
            }
            ++i;
        }
        return player;
    }

    public MudPlayer getMudPlayer(String name) {
        int i = 0;
        int length = this.size();
        boolean done = false;
        MudPlayer player = null;
        while (!done && i < length) {
            if (((MudPlayer)this.elementAt(i)).getName().toLowerCase().equals(name.toLowerCase())) {
                player = (MudPlayer)this.elementAt(i);
                done = true;
                continue;
            }
            ++i;
        }
        return player;
    }

    public MudPlayer getMudPlayer(MudPlayer p) {
        int i = 0;
        int length = this.size();
        boolean done = false;
        MudPlayer player = null;
        while (!done && i < length) {
            if (p.equals((MudPlayer)this.elementAt(i))) {
                player = (MudPlayer)this.elementAt(i);
                done = true;
                continue;
            }
            ++i;
        }
        return player;
    }

    public static PlayerMap loadMap() {
        MudPlayer[] mapAry = null;
        int highest = -1;
        PlayerMap map = null;
        try {
            File f = new File("tween.players.dat");
            if (f.exists()) {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream("tween.players.dat"));
                mapAry = (MudPlayer[])in.readObject();
                in.close();
                map = new PlayerMap();
                int j = 0;
                while (j < mapAry.length) {
                    if (highest < mapAry[j].getId()) {
                        highest = mapAry[j].getId();
                    }
                    map.fastAdd(mapAry[j]);
                    ++j;
                }
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe.toString());
        }
        catch (ClassNotFoundException cnf) {
            System.out.println(cnf.toString());
        }
        return map;
    }

    public boolean playerExists(int id) {
        int i = 0;
        int length = this.size();
        boolean done = false;
        MudPlayer player = null;
        boolean rc = false;
        while (!done && i < length) {
            player = (MudPlayer)this.elementAt(i);
            if (player.getId() == id) {
                rc = true;
                done = true;
                continue;
            }
            ++i;
        }
        return rc;
    }

    public boolean playerExists(String name) {
        int i = 0;
        int length = this.size();
        boolean done = false;
        MudPlayer player = null;
        boolean rc = false;
        while (!done && i < length) {
            if (((MudPlayer)this.elementAt(i)).getName().equals(name)) {
                player = (MudPlayer)this.elementAt(i);
                rc = true;
                done = true;
                continue;
            }
            ++i;
        }
        return rc;
    }

    public boolean playerExists(MudPlayer theMudPlayer) {
        int i = 0;
        int length = this.size();
        boolean done = false;
        MudPlayer player = null;
        boolean rc = false;
        while (!done && i < length) {
            player = (MudPlayer)this.elementAt(i);
            if (theMudPlayer.equals(player)) {
                done = true;
                rc = true;
                continue;
            }
            ++i;
        }
        return rc;
    }

    public void setMapFilename(String mapFilename) {
        this.mapFilename = mapFilename;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.size()) {
            MudPlayer aMudPlayer = (MudPlayer)this.elementAt(i);
            sb.append(aMudPlayer.toMap());
            ++i;
        }
        return sb.toString();
    }
}

