/*
 * Decompiled with CFR 0.152.
 */
package mstar;

import gnu.regexp.RE;
import gnu.regexp.REException;
import java.io.Serializable;
import java.util.GregorianCalendar;
import java.util.Vector;
import mstar.Exit;

public class Room
implements Serializable {
    String name = null;
    String dbReference = null;
    String description = null;
    String[] commands = null;
    String[] shownExits = null;
    String[] possibleExits = null;
    String[] contents = null;
    String[] chatter = null;
    int id = -1;
    int shownExitsIndex = 0;
    int possibleExitsIndex = 0;
    Exit[] goodExits = null;
    Exit[] badExits = null;
    Exit[] suspectExits = null;
    boolean visited = false;
    boolean confusingPathTo = false;
    GregorianCalendar firstIn = null;
    GregorianCalendar lastIn = null;
    long totalTimeIn = -1L;
    boolean usePossibleExits = false;
    boolean useFallbackExits = false;
    String[] fallbackExits = null;
    int fallbackExitsIndex = 0;

    public Room() {
    }

    public Room(String name) {
        this.setName(name);
    }

    public void addBadExit(Exit e) {
        Exit[] newExits = null;
        if (this.badExits == null) {
            this.badExits = new Exit[1];
            this.badExits[0] = e;
        } else {
            newExits = new Exit[this.badExits.length + 1];
            int i = 0;
            while (i < this.badExits.length) {
                newExits[i] = this.badExits[i];
                ++i;
            }
            newExits[i] = e;
            this.badExits = newExits;
        }
    }

    public void addContents(String c) {
        String[] newContents = null;
        if (this.contents == null) {
            this.contents = new String[1];
            this.contents[0] = c;
        } else {
            newContents = new String[this.contents.length + 1];
            int i = 0;
            while (i < this.contents.length) {
                newContents[i] = this.contents[i];
                ++i;
            }
            newContents[i] = c;
            this.contents = newContents;
        }
    }

    public void addGoodExit(Exit e) {
        Exit[] newExits = null;
        if (this.goodExits == null) {
            this.goodExits = new Exit[1];
            this.goodExits[0] = e;
        } else {
            newExits = new Exit[this.goodExits.length + 1];
            int i = 0;
            while (i < this.goodExits.length) {
                newExits[i] = this.goodExits[i];
                ++i;
            }
            newExits[i] = e;
            this.goodExits = newExits;
        }
    }

    public void addSuspectExit(Exit e) {
        Exit[] newExits = null;
        if (this.suspectExits == null) {
            this.suspectExits = new Exit[1];
            this.suspectExits[0] = e;
        } else {
            newExits = new Exit[this.suspectExits.length + 1];
            int i = 0;
            while (i < this.goodExits.length) {
                newExits[i] = this.suspectExits[i];
                ++i;
            }
            this.suspectExits[i] = e;
            this.suspectExits = newExits;
        }
    }

    public void clearVisitedExits() {
        Exit[] good = this.getGoodExits();
        if (good != null) {
            int length = good.length;
            int i = 0;
            while (i < length) {
                good[i].clearVisited();
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsObject(String object) {
        int i = 0;
        boolean done = false;
        boolean rc = false;
        RE re = null;
        if (this.contents == null) return rc;
        try {
            re = new RE((Object)(".*" + object.toLowerCase() + ".*"));
            while (!done) {
                if (i >= this.contents.length) {
                    return rc;
                }
                if (re.isMatch((Object)this.contents[i].toLowerCase())) {
                    done = true;
                    rc = true;
                    continue;
                }
                ++i;
            }
            return rc;
        }
        catch (REException rEException) {
            return rc;
        }
    }

    public boolean equals(Room r) {
        boolean d = false;
        boolean e = false;
        boolean n = false;
        if (this.getName() != null && r.getName() != null) {
            n = this.getName().equals(r.getName());
        } else if (this.getName() == null && r.getName() == null) {
            n = true;
        }
        if (this.getDescription() != null && r.getDescription() != null) {
            d = this.getDescription().equals(r.getDescription());
        } else if (this.getDescription() == null && r.getDescription() == null) {
            d = true;
        }
        if (this.shownExits != null && r.shownExits != null) {
            e = this.exitsAreEqual(this.shownExits, r.shownExits);
        } else if (this.shownExits == null && r.shownExits == null) {
            e = true;
        }
        return n && d && e;
    }

    public boolean exitExists(int e) {
        boolean rc = false;
        int i = 0;
        boolean done = false;
        if (this.goodExits != null) {
            while (!done && i < this.goodExits.length) {
                if (this.goodExits[i].getToRoom() == e) {
                    rc = true;
                    done = true;
                    continue;
                }
                ++i;
            }
        }
        return rc;
    }

    boolean exitsAreEqual(String[] e1, String[] e2) {
        boolean rc = true;
        if (e1.length != e2.length) {
            rc = false;
        } else {
            int length = e1.length;
            int i = 0;
            while (i < length) {
                if (!e1[i].equals(e2[i])) {
                    rc = false;
                }
                ++i;
            }
        }
        return rc;
    }

    public Exit[] getBadExits() {
        return this.badExits;
    }

    public String[] getChatter() {
        return this.chatter;
    }

    public String[] getCommands() {
        return this.commands;
    }

    public String[] getContents() {
        return this.contents;
    }

    public String getDBReference() {
        return this.dbReference;
    }

    public String getDescription() {
        return this.description;
    }

    public Exit getExit(int e) {
        Exit rc = null;
        int i = 0;
        boolean done = false;
        while (!done && i < this.goodExits.length) {
            if (this.goodExits[i].getToRoom() == e) {
                rc = this.goodExits[i];
                done = true;
                continue;
            }
            ++i;
        }
        return rc;
    }

    public String[] getFallbackExits() {
        return this.fallbackExits;
    }

    public GregorianCalendar getFirstIn() {
        return this.firstIn;
    }

    public Exit[] getGoodExits() {
        return this.goodExits;
    }

    public int getId() {
        return this.id;
    }

    public GregorianCalendar getLastIn() {
        return this.lastIn;
    }

    public String getName() {
        return this.name;
    }

    public String getNextUnexploredExit() {
        String rc = null;
        if (this.hasUnexploredExits()) {
            if (this.shownExits != null && this.shownExitsIndex < this.shownExits.length) {
                rc = this.shownExits[this.shownExitsIndex++];
            } else if (this.possibleExits != null && this.getUsePossibleExits() && this.possibleExitsIndex < this.possibleExits.length) {
                rc = this.possibleExits[this.possibleExitsIndex++];
            } else if (this.fallbackExits != null && this.getUseFallbackExits() && this.fallbackExitsIndex < this.fallbackExits.length) {
                rc = this.fallbackExits[this.fallbackExitsIndex++];
            }
        }
        return rc;
    }

    public Exit getNextUnvisitedExit() {
        Exit rc = null;
        boolean done = false;
        int i = 0;
        if (this.hasUnvisitedExits()) {
            while (!done && i < this.goodExits.length) {
                if (!this.goodExits[i].hasBeenVisited()) {
                    done = true;
                    rc = this.goodExits[i];
                    continue;
                }
                ++i;
            }
        }
        return rc;
    }

    public String[] getPossibleExits() {
        return this.possibleExits;
    }

    public String[] getShownExits() {
        return this.shownExits;
    }

    public Exit[] getSuspectExits() {
        return this.badExits;
    }

    public long getTotalTimeIn() {
        return this.totalTimeIn;
    }

    public boolean getUseFallbackExits() {
        return this.useFallbackExits;
    }

    public boolean getUsePossibleExits() {
        return this.usePossibleExits;
    }

    public boolean getVisited() {
        return this.visited;
    }

    public boolean hasConfusingPathTo() {
        return this.confusingPathTo;
    }

    public boolean hasUnexploredExits() {
        boolean rc = false;
        if (!this.confusingPathTo) {
            if (this.shownExits != null && this.shownExitsIndex < this.shownExits.length) {
                rc = true;
            }
            if (this.getUsePossibleExits() && this.possibleExits != null && this.possibleExitsIndex < this.possibleExits.length) {
                rc = true;
            }
            if (this.getUseFallbackExits() && this.fallbackExits != null && this.fallbackExitsIndex < this.fallbackExits.length) {
                rc = true;
            }
        }
        return rc;
    }

    public boolean hasUnvisitedExits() {
        boolean rc = false;
        boolean done = false;
        int i = 0;
        if (this.goodExits != null) {
            while (!done && i < this.goodExits.length) {
                if (!this.goodExits[i].hasBeenVisited()) {
                    done = true;
                    rc = true;
                    continue;
                }
                ++i;
            }
        }
        return rc;
    }

    public void moveGoodExitToSuspectExit(Exit e) {
        this.addSuspectExit(e);
        this.removeGoodExit(e);
    }

    public void removeBadExit(Exit e) {
        int j = 0;
        Exit[] newExits = null;
        if (this.badExits != null) {
            newExits = new Exit[this.badExits.length - 1];
            int i = 0;
            while (i < this.badExits.length) {
                if (!this.badExits[i].equal(e)) {
                    newExits[j++] = this.badExits[i];
                }
                ++i;
            }
            this.badExits = newExits;
        }
    }

    public void removeGoodExit(Exit e) {
        int j = 0;
        Exit[] newExits = null;
        if (this.goodExits != null) {
            newExits = new Exit[this.goodExits.length - 1];
            int i = 0;
            while (i < this.goodExits.length) {
                if (!this.goodExits[i].equal(e)) {
                    newExits[j++] = this.goodExits[i];
                }
                ++i;
            }
            this.goodExits = newExits;
        }
    }

    public void setChatter(Vector v) {
        if (v != null && v.size() > 0) {
            this.chatter = new String[v.size()];
            v.copyInto(this.chatter);
        }
    }

    public void setCommands(String[] commands) {
        this.commands = commands;
    }

    public void setConfusingPathTo(boolean confusingPathTo) {
        this.confusingPathTo = confusingPathTo;
    }

    public void setDBReference(String dbReference) {
        this.dbReference = dbReference;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFallbackExits(String[] fallbackExits) {
        this.fallbackExits = fallbackExits;
    }

    public void setFirstIn(GregorianCalendar firstIn) {
        this.firstIn = firstIn;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setLastIn(GregorianCalendar lastIn) {
        this.lastIn = lastIn;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPossibleExits(String[] possibleExits) {
        this.possibleExits = possibleExits;
    }

    public void setShownExits(String[] shownExits) {
        this.shownExits = shownExits;
    }

    public void setTotalTimeIn(long totalTimeIn) {
        this.totalTimeIn = totalTimeIn;
    }

    public void setUseFallbackExits(boolean useFallbackExits) {
        this.useFallbackExits = useFallbackExits;
    }

    public void setUsePossibleExits(boolean usePossibleExits) {
        this.usePossibleExits = usePossibleExits;
    }

    public void setVisited(boolean visited) {
        this.visited = visited;
    }

    public String shownExitsToString() {
        StringBuffer sb = null;
        sb = new StringBuffer();
        if (this.shownExits != null) {
            int i = 0;
            while (i < this.shownExits.length) {
                sb.append(this.shownExits[i]).append(" ");
                ++i;
            }
        }
        return sb.toString();
    }

    public String toMap() {
        int i;
        Exit[] good = this.getGoodExits();
        Exit[] bad = this.getBadExits();
        StringBuffer sb = new StringBuffer();
        if (this.hasConfusingPathTo()) {
            sb.append("# confusing path to this room\r\n");
        }
        sb.append("R:").append(this.getId()).append(" ").append(this.getName()).append("\r\n");
        if (this.getDescription() != null && !this.getDescription().equals("")) {
            sb.append("D:").append(this.getDescription()).append("\r\n");
        }
        if (this.getLastIn() != null && this.getFirstIn() != null) {
            sb.append("F:-1\t").append(this.getFirstIn().getTime().getTime()).append("\t").append(this.getLastIn().getTime().getTime()).append("\r\n");
        }
        if (good != null) {
            i = 0;
            while (i < good.length) {
                if (good[i].isConfusing()) {
                    sb.append("# next exit confusing\r\n");
                }
                sb.append("E:").append(good[i].getToRoom()).append("\t").append(good[i].getDirection()).append("\r\n");
                ++i;
            }
        }
        if (bad != null) {
            i = 0;
            while (i < bad.length) {
                if (bad[i] != null) {
                    sb.append("B:").append(bad[i].getDirection()).append("\r\n");
                }
                ++i;
            }
        }
        if (this.getContents() != null) {
            i = 0;
            while (i < this.contents.length) {
                if (this.contents[i] != null) {
                    sb.append("C:").append(this.contents[i]).append("\r\n");
                }
                ++i;
            }
        }
        sb.append("\r\n");
        return sb.toString();
    }

    public String toString() {
        return this.getName();
    }
}

