/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.StringTokenizer;
import java.util.Vector;

public class KeyValue {
    String key = "";
    boolean booleanValue = false;
    char charValue = '\u0000';
    byte byteValue = 0;
    short shortValue = 0;
    int intValue = 0;
    long longValue = 0L;
    float floatValue = 0.0f;
    double doubleValue = 0.0;
    String stringValue = "";
    int type = 0;
    Object objectValue = null;
    public static final int BOOLEAN = 1;
    public static final int CHAR = 2;
    public static final int BYTE = 4;
    public static final int SHORT = 8;
    public static final int INT = 16;
    public static final int LONG = 32;
    public static final int FLOAT = 64;
    public static final int DOUBLE = 128;
    public static final int STRING = 256;
    public static final int OBJECT = 512;

    public KeyValue(String theKey, byte theValue) {
        this.type = 4;
        this.key = theKey;
        this.byteValue = theValue;
    }

    public KeyValue(String theKey, char theValue) {
        this.type = 2;
        this.key = theKey;
        this.charValue = theValue;
    }

    public KeyValue(String theKey, double theValue) {
        this.type = 128;
        this.key = theKey;
        this.doubleValue = theValue;
    }

    public KeyValue(String theKey, float theValue) {
        this.type = 64;
        this.key = theKey;
        this.floatValue = theValue;
    }

    public KeyValue(String theKey, int theValue) {
        this.type = 16;
        this.key = theKey;
        this.intValue = theValue;
    }

    public KeyValue(String theKey, long theValue) {
        this.type = 32;
        this.key = theKey;
        this.longValue = theValue;
    }

    public KeyValue(String theKey, Object theValue) {
        this.type = 512;
        this.key = theKey;
        this.objectValue = theValue;
    }

    public KeyValue(String theKey, String theValue) {
        this.type = 256;
        this.key = theKey;
        this.stringValue = this.translateString(theValue);
    }

    public KeyValue(String theKey, short theValue) {
        this.type = 8;
        this.key = theKey;
        this.shortValue = theValue;
    }

    public KeyValue(String theKey, boolean theValue) {
        this.type = 1;
        this.key = theKey;
        this.booleanValue = theValue;
    }

    private String escapeString(String s) {
        StringBuffer buffer = new StringBuffer();
        int len = s.length();
        int i = 0;
        while (i < len) {
            if (s.charAt(i) == '\n') {
                buffer.append("\\\\n");
            } else if (s.charAt(i) == '\t') {
                buffer.append("\\\\t");
            } else {
                buffer.append(s.charAt(i));
            }
            ++i;
        }
        return buffer.toString();
    }

    public boolean getBoolean() {
        return this.booleanValue;
    }

    public byte getByte() {
        return this.byteValue;
    }

    public char getChar() {
        return this.charValue;
    }

    public double getDouble() {
        return this.doubleValue;
    }

    public float getFloat() {
        return this.floatValue;
    }

    public int getInt() {
        return this.intValue;
    }

    public String getKey() {
        return this.key;
    }

    public long getLong() {
        return this.longValue;
    }

    public Object getObject() {
        return this.objectValue;
    }

    public short getShort() {
        return this.shortValue;
    }

    public String getString() {
        return this.stringValue;
    }

    public int getType() {
        return this.type;
    }

    public boolean isBoolean() {
        return this.type == 1;
    }

    public boolean isByte() {
        return this.type == 4;
    }

    public boolean isChar() {
        return this.type == 2;
    }

    public boolean isDouble() {
        return this.type == 128;
    }

    public boolean isFloat() {
        return this.type == 64;
    }

    public boolean isInt() {
        return this.type == 16;
    }

    public boolean isLong() {
        return this.type == 32;
    }

    public boolean isObject() {
        return this.type == 512;
    }

    public boolean isShort() {
        return this.type == 8;
    }

    public boolean isString() {
        return this.type == 256;
    }

    public void set(byte value) {
        if (this.isByte()) {
            this.byteValue = value;
        }
    }

    public void set(char value) {
        if (this.isChar()) {
            this.charValue = value;
        }
    }

    public void set(double value) {
        if (this.isDouble()) {
            this.doubleValue = value;
        }
    }

    public void set(float value) {
        if (this.isFloat()) {
            this.floatValue = value;
        }
    }

    public void set(int value) {
        if (this.isInt()) {
            this.intValue = value;
        }
    }

    public void set(long value) {
        if (this.isLong()) {
            this.longValue = value;
        }
    }

    public void set(Object value) {
        if (this.isObject()) {
            this.objectValue = value;
        }
    }

    public void set(String value) {
        if (this.isString()) {
            this.stringValue = value;
        }
    }

    public void set(short value) {
        if (this.isShort()) {
            this.shortValue = value;
        }
    }

    public void set(boolean value) {
        if (this.isBoolean()) {
            this.booleanValue = value;
        }
    }

    public void setKey(String s) {
        this.key = s;
    }

    public static KeyValue[] toKeyValues(String s) {
        KeyValue aKeyValue;
        String value;
        String fieldName;
        int i;
        Vector<KeyValue> vector = new Vector<KeyValue>();
        StringTokenizer crST = new StringTokenizer(s, "\n");
        String token = crST.nextToken();
        while (crST.hasMoreTokens()) {
            i = token.indexOf(58);
            if (i != -1) {
                fieldName = token.substring(0, i);
                value = token.substring(++i);
                aKeyValue = new KeyValue(fieldName, value);
                vector.addElement(aKeyValue);
            }
            token = crST.nextToken();
        }
        i = token.indexOf(58);
        if (i != -1) {
            fieldName = token.substring(0, i);
            value = token.substring(++i);
            aKeyValue = new KeyValue(fieldName, value);
            vector.addElement(aKeyValue);
        }
        Object[] keyValues = new KeyValue[vector.size()];
        vector.copyInto(keyValues);
        return keyValues;
    }

    public String toString() {
        String buffer = "";
        buffer = String.valueOf(this.key) + ":";
        if (this.isBoolean()) {
            buffer = String.valueOf(buffer) + String.valueOf(this.booleanValue);
        } else if (this.isChar()) {
            buffer = String.valueOf(buffer) + String.valueOf(this.charValue);
        } else if (this.isByte()) {
            buffer = String.valueOf(buffer) + String.valueOf(this.byteValue);
        } else if (this.isShort()) {
            buffer = String.valueOf(buffer) + String.valueOf(this.shortValue);
        } else if (this.isInt()) {
            buffer = String.valueOf(buffer) + String.valueOf(this.intValue);
        } else if (this.isLong()) {
            buffer = String.valueOf(buffer) + String.valueOf(this.longValue);
        } else if (this.isFloat()) {
            buffer = String.valueOf(buffer) + String.valueOf(this.floatValue);
        } else if (this.isDouble()) {
            buffer = String.valueOf(buffer) + String.valueOf(this.doubleValue);
        } else if (this.isString()) {
            buffer = String.valueOf(buffer) + this.escapeString(this.stringValue);
        } else if (this.isObject()) {
            buffer = String.valueOf(buffer) + String.valueOf(this.objectValue.toString());
        }
        return buffer;
    }

    String translateString(String s) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int len = s.length();
        while (i < len) {
            if (s.charAt(i) == '\\') {
                if (s.charAt(++i) == 'n') {
                    buffer.append("\n");
                } else if (s.charAt(i) == 't') {
                    buffer.append("\t");
                } else {
                    buffer.append(s.charAt(i));
                }
            } else {
                buffer.append(s.charAt(i));
            }
            ++i;
        }
        return buffer.toString();
    }
}

