/*
 * Decompiled with CFR 0.152.
 */
package org.place.pj;

import java.util.Hashtable;
import java.util.Vector;
import org.place.pj.InvalidCommandlineArgument;
import org.place.pj.MissingCommandlineArgument;

public class Commandline {
    public String[] params;
    Hashtable optionlist;
    public boolean debug = false;

    public Commandline(String[] argv, String validflags, String validoptions) throws InvalidCommandlineArgument {
        String[] nullarray = new String[]{};
        this.doParse(argv, validflags, validoptions, nullarray, nullarray);
    }

    public Commandline(String[] argv, String validflags, String validoptions, String requiredoptions, String[] validlongflags, String[] validlongoptions, String[] requiredlongoptions) throws InvalidCommandlineArgument, MissingCommandlineArgument {
        boolean missedsome = false;
        String missed = "Missing Commandline Option(s): ";
        String[] tempvalidoptions = new String[validlongoptions.length + requiredlongoptions.length];
        int j = 0;
        int i = 0;
        while (i < validlongoptions.length) {
            tempvalidoptions[j] = validlongoptions[i];
            ++i;
            ++j;
        }
        i = 0;
        while (i < requiredlongoptions.length) {
            tempvalidoptions[j] = requiredlongoptions[i];
            ++i;
            ++j;
        }
        this.doParse(argv, validflags, String.valueOf(validoptions) + requiredoptions, validlongflags, tempvalidoptions);
        i = 0;
        while (i < requiredoptions.length()) {
            if (!this.hasOption(new Character(requiredoptions.charAt(i)))) {
                missed = String.valueOf(missed) + " " + new Character(requiredoptions.charAt(i)).toString();
                missedsome = true;
            }
            ++i;
        }
        i = 0;
        while (i < requiredlongoptions.length) {
            if (!this.hasOption(requiredlongoptions[i])) {
                missed = String.valueOf(missed) + " " + requiredlongoptions[i];
                missedsome = true;
            }
            ++i;
        }
        if (missedsome) {
            throw new MissingCommandlineArgument(missed);
        }
    }

    public Commandline(String[] argv, String validflags, String validoptions, String[] validlongflags, String[] validlongoptions) throws InvalidCommandlineArgument {
        this.doParse(argv, validflags, validoptions, validlongflags, validlongoptions);
    }

    void doParse(String[] argv, String validflags, String validoptions, String[] validlongflags, String[] validlongoptions) throws InvalidCommandlineArgument {
        boolean shouldthrow = false;
        String throwstring = new String("Invalid Commandline argument(s): ");
        Hashtable<String, Boolean> possopts = new Hashtable<String, Boolean>();
        boolean moreargs = true;
        Vector<String> paramv = new Vector<String>(1, 1);
        this.optionlist = new Hashtable(1, 1.0f);
        int i = 0;
        while (i < validlongflags.length) {
            if (this.debug) {
                System.out.println("debug: Looking for arg \"" + validlongflags[i] + "\"");
            }
            possopts.put(validlongflags[i], Boolean.FALSE);
            ++i;
        }
        i = 0;
        while (i < validlongoptions.length) {
            if (this.debug) {
                System.out.println("debug: Looking for arg \"" + validlongoptions[i] + "\"");
            }
            possopts.put(validlongoptions[i], Boolean.TRUE);
            ++i;
        }
        i = 0;
        while (i < validflags.length()) {
            if (this.debug) {
                System.out.println("debug: Looking for arg " + new Character(validflags.charAt(i)).toString());
            }
            possopts.put(new Character(validflags.charAt(i)).toString(), Boolean.FALSE);
            ++i;
        }
        i = 0;
        while (i < validoptions.length()) {
            if (this.debug) {
                System.out.println("debug: Looking for arg " + new Character(validoptions.charAt(i)).toString());
            }
            possopts.put(new Character(validoptions.charAt(i)).toString(), Boolean.TRUE);
            ++i;
        }
        i = 0;
        while (i < argv.length) {
            String arg = argv[i];
            if (this.debug) {
                System.out.println("debug: Arg \"" + arg + "\": ");
            }
            if (moreargs) {
                String optarg;
                int o;
                if (arg.equalsIgnoreCase("--")) {
                    moreargs = false;
                } else if (this.islongopt(arg)) {
                    o = 0;
                    arg = arg.substring(2);
                    if (this.debug) {
                        System.out.println("debug:   looking for internal flag \"" + arg + "\"");
                    }
                    if (possopts.containsKey(arg)) {
                        if (possopts.get(arg) == Boolean.FALSE) {
                            this.sethasflag(arg);
                        } else {
                            optarg = this.paramfor(argv, i, ++o);
                            this.sethasoption(arg, optarg);
                            if (optarg == null) {
                                --o;
                            }
                        }
                    } else {
                        throwstring = String.valueOf(throwstring) + " " + arg;
                        shouldthrow = true;
                    }
                    i += o;
                } else if (this.isoptlist(arg)) {
                    o = 0;
                    int j = 1;
                    while (j < arg.length()) {
                        String charatj = new Character(arg.charAt(j)).toString();
                        if (possopts.containsKey(charatj)) {
                            if (possopts.get(charatj) == Boolean.FALSE) {
                                this.sethasflag(charatj);
                            } else {
                                optarg = this.paramfor(argv, i, ++o);
                                this.sethasoption(charatj, optarg);
                                if (optarg == null) {
                                    --o;
                                }
                            }
                        } else {
                            throwstring = String.valueOf(throwstring) + " " + charatj;
                            shouldthrow = true;
                        }
                        ++j;
                    }
                    i += o;
                } else {
                    paramv.addElement(arg);
                    if (this.debug) {
                        System.out.println("debug:   has param " + arg);
                    }
                }
            } else {
                paramv.addElement(arg);
                if (this.debug) {
                    System.out.println("debug:   has param " + arg);
                }
            }
            ++i;
        }
        this.params = new String[paramv.size()];
        paramv.copyInto(this.params);
        if (shouldthrow) {
            throw new InvalidCommandlineArgument(throwstring);
        }
    }

    public String getOption(Character option) {
        return this.getOption(option.toString());
    }

    public String getOption(String option) {
        return ((StringHolder)this.optionlist.get((Object)option)).contents;
    }

    public boolean hasOption(Character option) {
        return this.hasOption(option.toString());
    }

    public boolean hasOption(String option) {
        return this.optionlist.containsKey(option);
    }

    boolean islongopt(String s) {
        return s.length() > 2 && s.charAt(0) == '-' && s.charAt(1) == '-';
    }

    boolean isoptlist(String s) {
        if (this.debug) {
            System.out.println("debug:   calling isoptlist(" + s + ")");
        }
        return s.length() > 1 && s.charAt(0) == '-';
    }

    String paramfor(String[] arglist, int optat, int argat) {
        int i = optat + 1;
        while (i <= optat + argat) {
            if (i >= arglist.length || this.isoptlist(arglist[i])) {
                if (this.debug) {
                    System.out.print("debug:   escaping paramfor early");
                    if (i >= arglist.length) {
                        System.out.println(" cuz arglist is too short.");
                    } else {
                        System.out.println(" cuz we hit a new opt list.");
                    }
                }
                return null;
            }
            ++i;
        }
        return arglist[optat + argat];
    }

    synchronized void sethasflag(String s) {
        if (this.debug) {
            System.out.println("debug:   has flag " + s);
        }
        this.optionlist.put(s, new StringHolder(null));
    }

    synchronized void sethasoption(String o, String p) {
        if (this.debug) {
            System.out.println("debug:   has option " + o + " with value " + p);
        }
        this.optionlist.put(o, new StringHolder(p));
    }

    public static void test(String[] in, String flags, String opts, String[] longflags, String[] longopts) {
        System.out.println("Valid short options are: " + opts + " (with args) and " + flags + " (without args).");
        System.out.println("Valid long options are: ");
        int i = 0;
        while (i < longopts.length) {
            System.out.println("  " + longopts[i]);
            ++i;
        }
        System.out.println("Valid long flags are: ");
        int i2 = 0;
        while (i2 < longflags.length) {
            System.out.println("  " + longflags[i2]);
            ++i2;
        }
        System.out.print("Running with options: ");
        int i3 = 0;
        while (i3 < in.length) {
            System.out.print(String.valueOf(in[i3]) + " ");
            ++i3;
        }
        System.out.println(" ...");
        try {
            String option;
            Commandline c = new Commandline(in, flags, opts, longflags, longopts);
            opts = String.valueOf(opts) + flags;
            int i4 = 0;
            while (i4 < opts.length()) {
                option = opts.substring(i4, i4 + 1);
                if (c.hasOption(option)) {
                    System.out.print("... found option " + option + " with value " + c.getOption(option) + "\n");
                } else {
                    System.out.print("... didn't find option " + option + "\n");
                }
                ++i4;
            }
            int i5 = 0;
            while (i5 < longopts.length + longflags.length) {
                option = i5 < longopts.length ? longopts[i5] : longflags[i5 - longopts.length];
                if (c.hasOption(option)) {
                    System.out.print("... found option " + option + " with value " + c.getOption(option) + "\n");
                } else {
                    System.out.print("... didn't find option " + option + "\n");
                }
                ++i5;
            }
            System.out.print("... Extra Parameters: ");
            int i6 = 0;
            while (i6 < c.params.length) {
                System.out.print(String.valueOf(c.params[i6]) + " ");
                ++i6;
            }
            System.out.print("\n");
        }
        catch (InvalidCommandlineArgument e) {
            System.out.println("Caught an Invalid command line argument:\n" + e.toString() + "\n");
        }
        System.out.println("Done.");
    }

    protected class StringHolder {
        public String contents;

        public StringHolder(String in) {
            this.contents = in;
        }
    }
}

