/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
package mstar;

import java.io.*;
import java.util.*;

/**
  * ParseWhere is a base level abstract class that is used to write
  * parsers for where command information that is returned from the 
  * collaborative environment. This class is subclassed for each of the 
  * different collaborative environments that are to be supported.
  *
  * @author Thaddeus O. Cooper (cooper@tweenproject.org)
  * @version 1.6
  */
public abstract class ParseWhere {

	/**
	  * Constructs a parser for parsing where command data returned from 
	  * the collaborative environment.
	  */
	public ParseWhere() {
		super();
	}

	/**
	  * Parses the where command data that is returned from the 
	  * collaborative environment and returns a String array that 
	  * represents the room the player is in.
	  *
	  * @param s the where command data from the collaborative environment 
	  *          that is to be parsed.
	  * @return a String array that represents the room where the player 
	  *           is.
	  */
	public abstract String[] parse(String s);
}
