/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
package mstar;

/**
  * The PathComponent is used as part of the path finding routines in the MUD
  * map. It represents a piece of a potential path that may result in a full
  * path being located between two rooms in the collaborative environment.
  *
  * @author Thaddeus O. Cooper (cooper@tweenproject.org)
  * @version 1.6
  */
public class PathComponent extends Exit {
	int	depth = -1;

	/**
	  * Creates an empty path component.
	  */
	public PathComponent() {
		super();
	}

	/**
	  * Sets the current search depth for this path.
	  *
	  * @param depth the current depth for the path search.
	  */
	public void setDepth(int depth) {
		this.depth = depth;
	}

	/**
	  * Gets the current search depth for this path.
	  *
	  * @return the current depth for the path search.
	  */
	public int getDepth() {
		return(this.depth);
	}

	/**
	  * Determines if this depth is equal to the depth that is being
	  * checked.
	  *
	  * @param depth the depth to be checked.
	  * @return true if the depths are equal, false otherwise.
	  */
	public boolean depthEquals(int depth) {
		return(getDepth() == depth);
	}

	/**
	  * Creates a String representation of this path component.
	  *
	  * @return a String representation of this path component.
	  */
	public String toString() {
		return(super.toString()+"\ndepth = "+depth);
	}
}
