/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
package mstar;

/**
  * This class defines an action for the robot to perform as part of a response
  * to another character in the collaborative environment.
  *
  * @author Thaddeus O. Cooper (cooper@tweenproject.org)
  * @version 1.6
  */
public class RobotAction {
	String	action   = null;
	String	response = null;

	/**
	  * Create an empty action and set the action to be DEFAULT.
	  */
	public RobotAction() {
		setAction("DEFAULT");
	}

	/**
	  * Create an action and set the response to the specified response.
	  *
	  * @param response the response the robot should send to the user
	  *                 that it is interacting with.
	  */
	public RobotAction(String response) {
		setResponse(response);
	}

	/**
	  * Create an action using the specified action and response.
	  *
	  * @param action the type of action the robot should use in its
	  *               response. For example, pose.
	  * @param response the response the robot should send to the user
	  *                 that it is interacting with.
	  */
	public RobotAction(String action, String response) {
		setAction(action);
		setResponse(response);
	}

	/**
	  * Sets the action that the robot should use in its response. For
	  * example, pose.
	  *
	  * @param action the type of action the robot should use in its
	  *               response. For example, pose.
	  */
	public void setAction(String action) {
		this.action = action;
	}

	/**
	  * Gets the action that the robot should use in its response. For
	  * example, pose.
	  *
	  * @return the type of action the robot should use in its response. 
	  *         For example, pose.
	  */
	public String getAction() {
		return(this.action);
	}

	/**
	  * Sets the response that the robot should send to the user that it
	  * is interacting with.
	  *
	  * @param response the response the robot should send to the user
	  *                 that it is interacting with.
	  */
	public void setResponse(String response) {
		this.response = response;
	}

	/**
	  * Gets the response that the robot should send to the user that it
	  * is interacting with.
	  *
	  * @return the response the robot should send to the user that it is 
	  *         interacting with.
	  */
	public String getResponse() {
		return(this.response);
	}

	/**
	  * Checks to see if the robot should use the default action instead
	  * of a programmer specified action. If the getAction routine returns
	  * default as its type then the robot should use the default action.
	  *
	  * @return true if the robot should use the default action, false
	  *         otherwise.
	  */
	public boolean shouldUseDefaultAction() {
		return(getAction().toLowerCase().equals("default"));
	}
}
