/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
package os;

import java.io.*;

/**
  * Implements a process table for managing process in the Bot Operating 
  * System.
  *
  * @author Thaddeus O. Cooper (cooper@tweenproject.org)
  * @version 1.0
  */
public class ProcessTable extends Queue {

	/**
	  * Gets the next process off of the queue to run.
	  *
	  * @return the next OSProcess to run.
	  */
	public OSProcess getNextProcess() {
		return((OSProcess)get());
	}

	/**
	  * Adds a process to the end of the queue.
	  *
	  * @param p the process to add to the end of the queue.
	  */
	public void addProcess(OSProcess p) {
		add(p);
	}

	/**
	  * Gets a specific process from the queue using the specified id.
	  *
	  * @param id the id of the process to retrieve from the process
	  *            queue.
	  * @return the specified process or null if it does not exist.
	  */
	public OSProcess getProcess(int id) {
		int		i;
		int		length;
		OSProcess	theProcess = null;
		boolean		done       = false;

		length = this.size();
		i = 0;
		while ((!done) && (i < length)) {
			if (((OSProcess)elementAt(i)).getId() == id) {
				done = true;
				theProcess = (OSProcess)elementAt(i);
			}
			else {
				i++;
			}
		}
		return(theProcess);
	}

	/**
	  * Create a string representation of the current state of the queue.
	  *
	  * @return a String that represents the current state of the queue.
	  */
	public String toString() {
		StringBuffer	sb = null;
		int		i;

		sb = new StringBuffer();
		sb.append("ID\tParen ID\tWait For\tInited\n");
		for (i = 0; i < this.size(); i++) {
			sb.append(((OSProcess)elementAt(i)).toString()).append("\n");
		}
		return(sb.toString());
	}
}
