/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
import gnu.regexp.*;
import mstar.*;

/**
  * The default chatter filter. This chatter filter passes anything in the
  * collaborative environment that mentions it, and all whispers, pages, 
  * emote, give, and paged to commands that are directed to it.
  *
  * @author Thaddeus O. Cooper (cooper@tweenproject.org)
  * @version 2.0
  */
public class defaultChatterFilter extends ChatterFilter {
	RE	botEcho        = null;
	RE	botMentioned   = null;
	RE	botPaged       = null;
	RE	botWhisperedTo = null;
	RE	botPagedTo     = null;
	String	robotName      = null;
	String	owner          = null;

	public defaultChatterFilter() {
		super();
	}

	public void initialize(String robotName) {
		setRobotName(robotName);
		if (getProperties() != null) {
			setOwner(getProperties().getProperty("robot.owner"));
		}
		try {
			botMentioned = new RE(".*"+getRobotName().toLowerCase()+".*", RE.REG_ICASE);
		}
		catch(REException ree) {
		}
	}

	public boolean accept(Chatter c) {
		boolean	sr = false;
		boolean rc = false;

		switch(c.getHow()) {
			case Chatter.MY_ACTION   :
				// always false...
				rc = false;
				break;
			case Chatter.UNDEFINED   :
				break;
			case Chatter.SAYS        :
				rc = botMentioned.isMatch(c.getWhat().toLowerCase());
				break;
			case Chatter.WHISPERS    :
				rc = true;
				break;
			case Chatter.PAGES       :
				rc = true;
				break;
			case Chatter.MUTTERS     :
				break;
			case Chatter.ARRIVES     :
				break;
			case Chatter.LEAVES      :
				break;
			case Chatter.POSES       :
				rc = botMentioned.isMatch(c.getWhat().toLowerCase());
				break;
			case Chatter.GIVES_OBJECT :
				rc = true;
				break;
			case Chatter.PAGED_TO    :
				rc = true;
				break;
			case Chatter.EMOTES      :
				rc = true;
				break;
			default                  :
				break;
		}
		return(rc);
	}

	public String getDescription() {
		return("a filter for tween");
	}

	public void setRobotName(String robotName) {
		this.robotName = robotName;
	}

	public String getRobotName() {
		return(this.robotName);
	}

	public void setOwner(String owner) {
		this.owner = owner;
	}

	public String getOwner() {
		return(this.owner);
	}
}
