/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
import gnu.regexp.*;
import java.util.*;
import java.io.*;
import java.net.*;
import util.*;
import mstar.*;

/**
  * Responds to requests to fetch URLs. It will only return data that is of the
  * MIME type text/*.
  *
  * @author Thaddeus O. Cooper (cooper@tweenproject.org)
  * @version 1.1
  */
public class FetchURLResponder extends Responder {
	String	url = null;

	protected void setURL(String url) {
		this.url = url;
	}

	protected String getURL() {
		return(this.url);
	}

	protected boolean fetchURL() {
		URL		theURL              = null;
		URLConnection	theURLConnection    = null;
		String		returnedContentType = null;
		StringBuffer	document            = null;
		String		aPiece              = null;
		boolean		rc                  = false;

		try {
			theURL = new URL(getURL());
			theURLConnection = theURL.openConnection();
			if (theURLConnection != null) {
				theURLConnection.setUseCaches(false);
				returnedContentType = theURLConnection.getContentType();
				if (returnedContentType == null) {
					addResponse("I was unable to fetch "+getURL()+" for you.");
				}
				else if (returnedContentType.toLowerCase().startsWith("text/")) {
					if (document == null) {
						document = new StringBuffer();
					}
					DataInputStream in = new DataInputStream(theURLConnection.getInputStream());
					boolean done = false;
					String  current;
	
System.out.println("about to read document for url "+getURL());
					while (!done) {
						current = in.readLine();
						if (current != null) {
							document.append(current);
						}
						else {
							done = true;
						}
					}
					rc = true;
					addResponse(document.toString());
				}
				else {
					addResponse("I was unable to fetch "+getURL()+" for you.");
				}
			}
		}
		catch (MalformedURLException e) {
			addAction("pose", "shrugs");
			addResponse("There was something wrong with the URL you asked me to fetch for you...");
		}
		catch (IOException e) {
			addAction("pose", "shrugs");
			addResponse("Something went wrong while I was trying to get your document...");
		}
		return(rc);
	}

	public void process() {
		fetchURL();
	}

	public String serviceType() {
		return("FETCH URL");
	}

	public boolean canProcess(Chatter c) {
		boolean	rc  = false;
		RE	re  = null;
		REMatch	rem = null;
		String	how = null;

		try {
			re = new RE(".*fetch url (.*)");
			if (c.getWhat() != null) {
				rc = re.isMatch(c.getWhat().toLowerCase().trim());
			}
			if (rc) {
				rem = re.getMatch(c.getWhat().toLowerCase());
				how = c.getWhat().substring(rem.getSubStartIndex(1));
				if ((c.getHow() == Chatter.SAYS) || (c.getHow() == Chatter.WHISPERS)) {
					setURL(Utility.removePunctuation(c.getWhat().substring(rem.getSubStartIndex(1))));
				}
				else {
					setURL(c.getWhat().substring(rem.getSubStartIndex(1)));
				}
			}
		}
		catch(REException ree) {
			rc = false;
		}
		return(rc);
	}
}
