/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
import gnu.regexp.*;
import java.util.*;
import util.*;
import mstar.*;

/**
  * Responds to a command for the robot to follow a list of comma delimited
  * directions.
  *
  * @author Thaddeus O. Cooper (cooper@tweenproject.org)
  * @version 1.1
  */
public class FollowDirectionsResponder extends Responder {
	String	directions = null;

	public void process() {
		String[]	directionsArray = null;
		int		i;

		if (directions != null) {
			if (directions.endsWith("\"")) {
				directions = directions.substring(0, directions.length()-1);
			}
			if (directions.length() > 0) {
				directionsArray = Utility.commaListToArray(directions);
				if (directionsArray != null) {
					for (i = 0; i < directionsArray.length; i++) {
						addRobotAction("GO", directionsArray[i]);
					}
				}
			}
		}
	}

	public String serviceType() {
		return("FOLLOWDIRECTIONS");
	}

	public boolean canProcess(Chatter c) {
		boolean	rc = false;
		RE	re  = null;
		REMatch	rem = null;

		if ((c.getHow() == Chatter.PAGES) || (c.getHow() == Chatter.WHISPERS)) {
			try {
				re = new RE(".*follow directions (.*)");
				rc = re.isMatch(c.getWhat().toLowerCase());
				if (rc) {
					rem = re.getMatch(c.getWhat().toLowerCase());
					directions = c.getWhat().substring(rem.getSubStartIndex(1));
				}
			}
			catch(REException ree) {
				rc = false;
			}
		}
		return(rc);
	}
}
