/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
import gnu.regexp.*;
import java.util.*;
import java.io.*;
import java.net.*;
import util.*;
import mstar.*;

/**
  * Responds to requests about what's new. The responder picks a headline news
  * story from one of its online newspapers and returns the information.
  *
  * @author Thaddeus O. Cooper
  * @version 1.2
  */
public class WhatsNewResponder extends Responder {
	static final char EOS = '\0';
	String	newsURLs[] = {
				"http://dailynews.yahoo.com/tx/ts/",
				"http://dailynews.yahoo.com/tx/bs/",
				"http://dailynews.yahoo.com/tx/sp/",
				"http://dailynews.yahoo.com/tx/wl/",
				"http://dailynews.yahoo.com/tx/tc/",
				"http://dailynews.yahoo.com/tx/pl/",
				"http://dailynews.yahoo.com/tx/sc/",
				"http://dailynews.yahoo.com/tx/hl/",
			     };
	String	stories[] = null;

	protected String getURL() {
		return(newsURLs[(int)(Math.random()*7.99)]);
	}

	protected boolean fetchURL() {
		URL		theURL              = null;
		URLConnection	theURLConnection    = null;
		String		returnedContentType = null;
		StringBuffer	document            = null;
		String		aPiece              = null;
		boolean		rc                  = false;
		Vector		docVector           = null;

		try {
			theURL = new URL(getURL());
			theURLConnection = theURL.openConnection();
			if (theURLConnection != null) {
				theURLConnection.setUseCaches(false);
				returnedContentType = theURLConnection.getContentType();
				if ((returnedContentType != null) && 
				    (returnedContentType.toLowerCase().startsWith("text/"))) {
					if (document == null) {
						document = new StringBuffer();
					}
					DataInputStream in = new DataInputStream(theURLConnection.getInputStream());
					boolean done = false;
					String  current;
	
					while (!done) {
						current = in.readLine();
						if (current != null) {
							if (current.toLowerCase().startsWith("<a href=")) {
								if (docVector == null) {
									docVector = new Vector();
								}
								docVector.addElement(current);
							}
						}
						else {
							done = true;
						}
					}
					rc = true;
					if ((docVector != null) && (docVector.size() > 0)) {
						stories = new String[docVector.size()];
						docVector.copyInto(stories);
					}
				}
			}
		}
		catch (MalformedURLException e) {
		}
		catch (IOException e) {
		}
		return(rc);
	}

	protected void buildResponse(String s) {
		int	state = 0;
		int	index = 0;
		boolean	done  = false;
		char	c     = EOS;
		StringBuffer	headline = null;
		StringBuffer	summary  = null;

		while (!done) {
			if (index < s.length()) {
				c = s.charAt(index);
			}
			else {
				c = '\0';
			}
			switch(state) {
				case  0 :
					switch(c) {
						case '<' :
							state = 1;
							index++;
							break;
						case EOS :
							state = 15;
							break;
						default  :
							index++;
							break;
					}
					break;
				case  1 :
					switch(c) {
						case 'b' :
						case 'B' :
							state = 2;
							index++;
							break;
						case EOS :
							state = 15;
							break;
						default  :
							state = 0;
							index++;
							break;
					}
					break;
				case  2 :
					switch(c) {
						case '>' :
							state = 3;
							index++;
							break;
						case EOS :
							state = 15;
							break;
						default  :
							state = 0;
							index++;
							break;
					}
					break;
				case  3 :
					switch(c) {
						case '<' :
							state = 4;
							index++;
							break;
						case EOS :
							state = 15;
							break;
						default  :
							if (headline == null) {
								headline = new StringBuffer();
							}
							headline.append(c);
							index++;
							break;
					}
					break;
				case  4 :
					switch(c) {
						case '/' :
							state = 5;
							index++;
							break;
						case EOS :
							state = 15;
							break;
						default  :
							state = 3;
							index++;
							break;
					}
					break;
				case  5 :
					switch(c) {
						case 'b' :
						case 'B' :
							state = 6;
							index++;
							break;
						case EOS :
							state = 15;
							break;
						default  :
							state = 3;
							index++;
							break;
					}
					break;
				case  6 :
					switch(c) {
						case '>' :
							state = 7;
							index++;
							break;
						case EOS :
							state = 15;
							break;
						default  :
							state = 3;
							index++;
							break;
					}
					break;
				case  7 :
					switch(c) {
						case '<' :
							state = 8;
							index++;
							break;
						case EOS :
							state = 15;
							break;
						default  :
							index++;
							break;
					}
					break;
				case  8 :
					switch(c) {
						case 'f' :
						case 'F' :
							state = 9;
							index++;
							break;
						case EOS :
							state = 15;
							break;
						default  :
							state = 7;
							index++;
							break;
					}
					break;
				case  9 :
					switch(c) {
						case 'o' :
						case 'O' :
							state = 10;
							index++;
							break;
						case EOS :
							state = 15;
							break;
						default  :
							state = 7;
							index++;
							break;
					}
					break;
				case 10 :
					switch(c) {
						case 'n' :
						case 'N' :
							state = 11;
							index++;
							break;
						case EOS :
							state = 15;
							break;
						default  :
							state = 7;
							index++;
							break;
					}
					break;
				case 11 :
					switch(c) {
						case 't' :
						case 'T' :
							state = 12;
							index++;
							break;
						case EOS :
							state = 15;
							break;
						default  :
							state = 7;
							index++;
							break;
					}
					break;
				case 12 :
					switch(c) {
						case '>' :
							state = 13;
							index++;
							break;
						case EOS :
							state = 15;
							break;
						default  :
							index++;
							break;
					}
					break;
				case 13 :
					switch(c) {
						case '<' :
							state = 14;
							index++;
							break;
						case EOS :
							state = 15;
							break;
						default  :
							if (summary == null) {
								summary = new StringBuffer();
							}
							summary.append(c);
							index++;
							break;
					}
					break;
				case 14 :
					addAction("pose", "scratches his head... -- I did see something interesting earlier");
					addAction("pose", "pulls out his newspaper -- here it is");
					addAction("pose", "points to a story");
					addResponse(headline.toString());
					addResponse(summary.toString());
					addAction("pose", "puts his newspaper away");
					done = true;
					break;
				case 15 :
					done = true;
					break;
				default :
					break;
			}
		}
	}

	public void process() {
		int	length = 0;
		int	index  = 0;

		if (fetchURL()) {
			length = stories.length;
			length--;
			index  = (int)(Math.random()*((double)length+0.99));
			buildResponse(stories[index]);
		}
	}

	public String serviceType() {
		return("NEWS");
	}

	public boolean canProcess(Chatter c) {
		boolean	rc            = false;
		RE	re    = null;
		REMatch	rem           = null;

		if (c.getWhat() != null) {
			try {
				re = new RE(".*what.*new.*");
				rc = re.isMatch(c.getWhat().toLowerCase().trim());
if (rc) System.out.println("matched");
				if (rc) {
					rem = re.getMatch(c.getWhat().toLowerCase().trim());
					//setWho(rem.toString(1));
					//setWhat(rem.toString(2).trim());
				}
			}
			catch(REException ree) {
				rc = false;
			}
		}
		return(rc);
	}
}
