/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
import gnu.regexp.*;
import java.util.*;
import java.io.*;
import util.*;
import mstar.*;

/**
  * Responds to questions about the current location of the robot in the
  * collaborative environment.
  *
  * @author Thaddeus O. Cooper (cooper@tweenproject.org)
  * @version 1.1
  */
public class WhereAreYouResponder extends Responder {
	Chatter	c = null;

	/**
	  */
	StringBuffer getRoomDescription() {
		StringBuffer	rd = null;
		String		aLine = null;

		try {
			getConnection().waitForData();
			aLine = getConnection().readLine();
			if (rd == null) {
				rd = new StringBuffer();
			}
			while (!aLine.startsWith(getConnection().getOutputSuffix())) {
				rd.append(aLine+"\n");
				aLine = getConnection().readLine();
			}
		}
		catch(IOException ioe) {
		}
		return(rd);
	}

	Room lookHere() {
		StringBuffer	rd = null;
		Room		room = null;

		getCommands().look("");
		getConnection().findOutputPrefix();
		rd = getRoomDescription();
		if (rd != null) {
			room = getRoomParser().parse(rd.toString());
		}
		return(room);
	}

	public void process() {
		Room	here = null;

		//if ((getHow() != null) && (getHow().toLowerCase().startsWith("says"))) {
		if ((c.getHow() == Chatter.SAYS) ||
		    (c.getHow() == Chatter.WHISPERS)) {
			addAction("pose", "looks at "+c.getWho()+" very confused like");
			addResponse("I am right here with you "+c.getWho());
		}
		else {
			here = lookHere();
			if (here != null) {
				addResponse("I am in "+here.getName());
			}
			else {
				addResponse("I am not sure where I am.");
			}
		}
	}

	public String serviceType() {
		return("ROOM INFORMATION");
	}

	public boolean canProcess(Chatter c) {
		boolean	rc = false;

		if (c.getWhat() != null) {
			this.c = c;
			try {
				rc = new RE(".*where are you.*").isMatch(c.getWhat().toLowerCase());
			}
			catch(REException ree) {
				rc = false;
			}
		}
		return(rc);
	}
}
////////
