/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
import gnu.regexp.*;
import java.util.*;
import util.*;
import mstar.*;

/**
  * Tries to handle all the input from characters in the collaborative
  * environment that the other responders didn't catch.
  *
  * @author Thaddeus O. Cooper (cooper@tweenproject.org)
  * @version 1.1
  */
public class defaultResponder extends Responder {
	Chatter	c = null;

	String	ouchResponses[] = {
					"OUCH! That hurt!",
					"OW!",
					"OUCH!",
				  };

	String helloResponses[] = {
					"Hello ",
					"Hi ",
					"Greetings ",
					"Greetings and salutations ",
					"Howdy do ",
					"Howdy ",
				  };

	String helloActions[] = {
					"Bows",
					"Curtsies",
					null,
					"Waves",
					"Jumps up and down",
				};

	String badWordResponses[] = {
					"%N, %N, %N, really!",
					"Really %N! I would prefer it if you did not used such language around me.",
					"%N, please! My virgin ears.",
					"%N!",
					"Really %N!",
					"%N really!",
					"%N please!",
					"Really %N, such language",
				    };

	String niceResponses[] = {
					"Thank you!",
					"Ohhh, I like that... :)",
					"Ohhhhh",
					"I need to come here more often...",
					"I like that...",
				 };

	String niceActions[] = {
					"Blushes",
					"Makes kat-like purring sounds...",
					"Giggles",
					"Likes that",
					"Likes that alot",
					"Wants %N to keep doing that",
			       };

	String defaultResponses[] = {
					"That's very interesting, please tell me more",
					"I didn't know that!",
					"Really?!?",
					null,
					"Really...",
					"That's interesting...",
				    };

	String defaultActions[] = {
					"Nods",
					"Nods -- please continue",
					"Wanders off",
					null,
					"Sits down and meditates",
					"Looks up at the sky -- nice weather, don't you think so?",
					"Shrugs and wanders around trying not to look bored.",
					"Strokes his chin",
					"Scratches his head",
				  };

	public void process() {
		String		badWordList           = null;
		StringBuffer	badWordRegExp         = null;
		String		fightingWordList      = null;
		StringBuffer	fightingWordRegExp    = null;
		String		helloWordList         = null;
		StringBuffer	helloWordRegExp       = null;
		String		goodbyeWordList       = null;
		StringBuffer	goodbyeRegExp         = null;
		String		goodnightWordList     = null;
		StringBuffer	goodnightRegExp       = null;
		String		goodafternoonWordList = null;
		StringBuffer	goodafternoonRegExp   = null;
		String		goodmorningWordList   = null;
		StringBuffer	goodmorningRegExp     = null;
		String		goodeveningWordList   = null;
		StringBuffer	goodeveningRegExp     = null;
		String		howareyouWordList     = null;
		StringBuffer	howareyouRegExp       = null;
		String		niceWordList          = null;
		StringBuffer	niceRegExp            = null;

		//if (getProperties() != null) {
		if (getProperties() == null) {
			setProperties(new Properties());
		}
			badWordList = getProperties().getProperty("robot.defaultResponder.badwords", "fuck,piss,shit");
			if (badWordList != null) {
				badWordRegExp = new StringBuffer();
				badWordRegExp.append(".*(").append(Utility.join(Utility.commaListToArray(badWordList), "|")).append(").*");
			}
			fightingWordList = getProperties().getProperty("robot.defaultResponder.fightingwords", "hit,kick,pummel");
			if (fightingWordList != null) {
				fightingWordRegExp = new StringBuffer();
				fightingWordRegExp.append(".*(").append(Utility.join(Utility.commaListToArray(fightingWordList), "|")).append(").*");
			}
			helloWordList = getProperties().getProperty("robot.defaultResponder.hellowords", "hello,hi");
			if (helloWordList != null) {
				helloWordRegExp = new StringBuffer();
				helloWordRegExp.append(".*(").append(Utility.join(Utility.commaListToArray(helloWordList), "|")).append(").*");
			}
			goodbyeWordList = getProperties().getProperty("robot.defaultResponder.goodbyewords", "goodbye,bye");
			if (goodbyeWordList != null) {
				goodbyeRegExp = new StringBuffer();
				goodbyeRegExp.append(".*(").append(Utility.join(Utility.commaListToArray(goodbyeWordList), "|")).append(").*");
			}
			goodnightWordList = getProperties().getProperty("robot.defaultResponder.goodnightwords", "goodnight,night");
			if (goodnightWordList != null) {
				goodnightRegExp = new StringBuffer();
				goodnightRegExp.append(".*(").append(Utility.join(Utility.commaListToArray(goodnightWordList), "|")).append(").*");
			}
			goodafternoonWordList = getProperties().getProperty("robot.defaultResponder.goodafternoonwords", "goodafternoon,afternoon");
			if (goodafternoonWordList != null) {
				goodafternoonRegExp = new StringBuffer();
				goodafternoonRegExp.append(".*(").append(Utility.join(Utility.commaListToArray(goodafternoonWordList), "|")).append(").*");
			}
			goodmorningWordList = getProperties().getProperty("robot.defaultResponder.goodmorningwords", "goodmorning,morning");
			if (goodmorningWordList != null) {
				goodmorningRegExp = new StringBuffer();
				goodmorningRegExp.append(".*(").append(Utility.join(Utility.commaListToArray(goodmorningWordList), "|")).append(").*");
			}
			goodeveningWordList = getProperties().getProperty("robot.defaultResponder.goodeveningwords", "goodevening,evening");
			if (goodeveningWordList != null) {
				goodeveningRegExp = new StringBuffer();
				goodeveningRegExp.append(".*(").append(Utility.join(Utility.commaListToArray(goodeveningWordList), "|")).append(").*");
			}
			howareyouWordList = getProperties().getProperty("robot.defaultResponder.howareyouwords", "how are you,how.*s life");
			if (howareyouWordList != null) {
				howareyouRegExp = new StringBuffer();
				howareyouRegExp.append(".*(").append(Utility.join(Utility.commaListToArray(howareyouWordList), "|")).append(").*");
			}
			niceWordList = getProperties().getProperty("robot.defaultResponder.nicewords", "hugs,kisses");
			if (niceWordList != null) {
				niceRegExp = new StringBuffer();
				niceRegExp.append(".*(").append(Utility.join(Utility.commaListToArray(niceWordList), "|")).append(").*");
			}
			System.out.println("bad word re is: '"+badWordRegExp.toString()+"'");
			System.out.println("fighting word re is: '"+fightingWordRegExp.toString()+"'");
		//}
		//else {
		//	System.out.println("no properties available");
		//}

		try {
			if (new RE(helloWordRegExp).isMatch(c.getWhat().toLowerCase().trim())) {
				addAction("pose", helloActions[(int)(Math.random()*4.99)]);
				addResponse(helloResponses[(int)(Math.random()*5.99)]+getWho());
			}
			else if (new RE(goodbyeRegExp).isMatch(c.getWhat().toLowerCase().trim())) {
				addResponse("Goodbye "+getWho());
			}
			else if (new RE(goodnightRegExp).isMatch(c.getWhat().toLowerCase().trim())) {
				addResponse("Goodnight "+getWho());
			}
			else if (new RE(goodafternoonRegExp).isMatch(c.getWhat().toLowerCase().trim())) {
				addResponse("Goodnight "+getWho());
			}
			else if (new RE(goodmorningRegExp).isMatch(c.getWhat().toLowerCase().trim())) {
				addResponse("Good morning "+getWho());
			}
			else if (new RE(goodeveningRegExp).isMatch(c.getWhat().toLowerCase().trim())) {
				addResponse("Good evening "+getWho());
			}
			else if (new RE(".*hey.*").isMatch(c.getWhat().toLowerCase().trim())) {
				addResponse("Yes "+getWho()+"?");
			}
			else if (new RE(howareyouRegExp).isMatch(c.getWhat().toLowerCase().trim())) {
				addResponse("I am fine "+getWho()+", how are you?");
			}
			else if (new RE(badWordRegExp.toString()).isMatch(c.getWhat().toLowerCase().trim())) {
				RE	templateRE = new RE("(%N)");
				REMatch	rem = templateRE.getMatch("Really \\%N! I would prefer it if you did not use such language around me.");
				addResponse(templateRE.substituteAll(badWordResponses[(int)(Math.random()*6.99)], getWho()));
			}
			else if (new RE(fightingWordRegExp).isMatch(c.getWhat().toLowerCase().trim())) {
				addResponse(ouchResponses[(int)(Math.random()*2.99)]);
				addAction("pose", "wonders why "+getWho()+" would want to do that to him.");
			}
			else if (new RE(niceRegExp).isMatch(c.getWhat().toLowerCase().trim())) {
				RE	templateRE = new RE("(%N)");
addResponse(templateRE.substituteAll(niceResponses[(int)(Math.random()*4.99)], getWho()));
addAction("pose", templateRE.substituteAll(niceActions[(int)(Math.random()*5.99)], getWho()));
			}
			else {
				//addAction("pose", "shrugs and wanders around trying not to look bored.");
				addResponse(defaultResponses[(int)(Math.random()*5.99)]);
				addAction("pose", defaultActions[(int)(Math.random()*8.99)]);
			}
		}
		catch(REException ree) {
		}
	}

	public String serviceType() {
		return("DEFAULT");
	}

	public boolean canProcess(Chatter c) {
		boolean	rc            = false;
		RE	re    = null;
		RE	sayService    = null;
		RE	actionService = null;
		REMatch	rem           = null;

		if (c.getWhat() != null) {
			this.c = c;
			try {
				re = new RE(".*");
				rc = re.isMatch(c.getWhat().toLowerCase().trim());
if (rc) System.out.println("matched");
				if (rc) {
					rem = re.getMatch(c.getWhat().toLowerCase().trim());
					this.c = c;
				}
			}
			catch(REException ree) {
				rc = false;
			}
		}
		return(rc);
	}
}
