/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
import java.io.*;
import java.util.*;
import os.*;
import mstar.*;
import org.place.pj.*;

/**
  * A Bot OS program to clear the chatter vector in the robot.
  *
  * @author Thaddeus O. Cooper (cooper@tweenproject.org)
  * @version 1.0
  */
public class ClearChatterVector extends OSProcess {
	static final String	DEFAULT_ROBOT_PROPERTIES_FILENAME = "robot.properties";
	Connection		mudConnection                     = null;
	Vector			chatterVector                     = null;
	Properties		properties                        = null;
	boolean			verbose                           = false;

	public void initialize() {
		String[]	args = null;
		Commandline	cl = null;
		String		longOptions[] = {
						};
		String		longFlags[] = {
						"verbose",
					      };
		FileInputStream	in = null;

		args = getArgs();
		try {
			cl = new Commandline(args,
					     "nowrv",
					     "",
					     longFlags,
					     longOptions);
			// first things first, see if there is a
			// properties file that was specified
			if (cl.hasOption("properties")) {
				try {
					in = new FileInputStream(cl.getOption("properties"));
					properties = new Properties();
					properties.load(in);
				}
				catch (IOException ioe) {
					System.out.println("Properties file '"+
							   cl.getOption("properties")+
							   "' not found.");
					System.exit(-1);
				}
			}
			else {
				try {
					// first look in the local directory...
					in = new FileInputStream(System.getProperty("user.dir")+
								 File.separator+DEFAULT_ROBOT_PROPERTIES_FILENAME);
					properties = new Properties();
					properties.load(in);
				}
				catch (IOException ioe) {
					try {
						// now try the home directory....
						in = new FileInputStream(System.getProperty("user.home")+
									 File.separator+DEFAULT_ROBOT_PROPERTIES_FILENAME);
						properties = new Properties();
						properties.load(in);
					}
					catch (IOException ioe1) {
					}
				}
			}
			if (properties != null) {
				verbose = properties.getProperty("asc.verbose", "false").toLowerCase().equals("true") ? true : false;	
			}

			if (cl.hasOption("v")) {
				verbose = true;
			}
			if (cl.hasOption("verbose")) {
				verbose = true;
			}
		}
		catch (InvalidCommandlineArgument ica) {
			System.out.println("invalid command line argument "+ica.toString());
		}
		if (mudConnection == null) {
			mudConnection = (Connection)requestObject("RobotConnection");
			if (mudConnection != null) {
				setInitialized(true);
			}
		}
	}

	public void run() throws OSProcessRelinquishControl,
				 OSProcessDone {
		Vector	chatterVector = null;

		chatterVector = mudConnection.getChatterVector();
		if (chatterVector != null) {
			chatterVector.clear();
			throw new OSProcessDone();
		}
		throw new OSProcessRelinquishControl();
	}
}
