/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
import java.io.*;
import java.util.*;
import os.*;
import mstar.*;

/**
  * A Bot OS program to send the go command to the collaborative environment
  * while the robot is running.
  *
  * @author Thaddeus Cooper (cooper@tweenproject.org)
  * @version 1.0
  */
public class Go extends OSProcess {
	Connection	mudConnection = null;
	Commands	commands      = null;
	int		state         = 0;
	String[]	args          = null;

	public void initialize() {
		if (args == null) {
			args = getArgs();
			if (args.equals("")) {
				System.out.println("nowhere to go");
			}
		}
		if (mudConnection == null) {
			mudConnection = (Connection)requestObject("RobotConnection");
		}
		if (commands == null) {
			commands = (Commands)requestObject("RobotCommands");
		}
		if ((mudConnection != null) && (commands != null)) {
			setInitialized(true);
		}
	}

	public void run() throws OSProcessDone {

		commands.go(args[1]);
		mudConnection.drainConnectionToSuffix();
		throw new OSProcessDone();
	}
}
