/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
import java.io.*;
import java.util.*;
import os.*;
import mstar.*;
import org.place.pj.*;

/**
  * A Bot OS program to load the appropriate connection class, for the 
  * particular collaborative environment that the robot is running in, during 
  * the robot's initialization phase.
  *
  * @author Thaddeus O. Cooper (cooper@tweenproject.org)
  * @version 1.0
  */
public class LoadConnection extends OSProcess {
	static final String	DEFAULT_ROBOT_PROPERTIES_FILENAME = "robot.properties";
	int		state = 0;
	DataInputStream	in    = null;
	FileInputStream	propertiesIn = null;
	PrintStream	out   = null;
	String		hostname = null;
	int		port     = 4201;
	String		robotName = null;
	String		mudType       = null;
	boolean		verbose	      = true;	/* if set to true the bot */
						/* prints a lot of        */
						/* information to stdout. */

	public void initialize() {
		String		portString = null;
		String[]	args = null;
		Commandline	cl = null;
		Properties	properties = null;
		String		longOptions[] = {
							"properties",
							"host",
							"port",
							"name",
							"mudtype",
						};
		String		longFlags[] = {
						"verbose",
					      };

		args = getArgs();
		try {
			cl = new Commandline(args,
					     "hpnmv",
					     "",
					     longFlags,
					     longOptions);
			// first things first, see if there is a
			// properties file that was specified
			if (cl.hasOption("properties")) {
				try {
					propertiesIn = new FileInputStream(cl.getOption("properties"));
					properties = new Properties();
					properties.load(propertiesIn);
				}
				catch (IOException ioe) {
					System.out.println("Properties file '"+
							   cl.getOption("properties")+
							   "' not found.");
					System.exit(-1);
				}
			}
			else {
				try {
					// first look in the local directory...
					propertiesIn = new FileInputStream(System.getProperty("user.dir")+
								 File.separator+DEFAULT_ROBOT_PROPERTIES_FILENAME);
					properties = new Properties();
					properties.load(propertiesIn);
				}
				catch (IOException ioe) {
					try {
						// now try the home directory....
						propertiesIn = new FileInputStream(System.getProperty("user.home")+
									 File.separator+DEFAULT_ROBOT_PROPERTIES_FILENAME);
						properties = new Properties();
						properties.load(propertiesIn);
					}
					catch (IOException ioe1) {
					}
				}
			}
			if (properties != null) {
				verbose = properties.getProperty("robot.verbose", "false").toLowerCase().equals("true") ? true : false;	
				hostname = properties.getProperty("robot.host");
				portString = properties.getProperty("robot.port");
				if (portString != null) {
					try {
						port = Integer.parseInt(portString);
					}
					catch(NumberFormatException nfe) {
						System.out.println(nfe.toString());
					}
				}
				robotName = properties.getProperty("robot.name");
				mudType = properties.getProperty("robot.mudType");
			}

			if (cl.hasOption("v")) {
				verbose = true;
			}
			if (cl.hasOption("verbose")) {
				verbose = true;
			}
			if (cl.hasOption("h")) {
				hostname = cl.getOption("h");
			}
			if (cl.hasOption("host")) {
				hostname = cl.getOption("host");
			}
			if (cl.hasOption("p")) {
				portString = cl.getOption("port");
				if (portString != null) {
					try {
						port = Integer.parseInt(portString);
					}
					catch(NumberFormatException nfe) {
						System.out.println(nfe.toString());
					}
				}
			}
			if (cl.hasOption("port")) {
				portString = cl.getOption("port");
				if (portString != null) {
					try {
						port = Integer.parseInt(portString);
					}
					catch(NumberFormatException nfe) {
						System.out.println(nfe.toString());
					}
				}
			}
			if (cl.hasOption("n")) {
				robotName = cl.getOption("n");
			}
			if (cl.hasOption("name")) {
				robotName = cl.getOption("name");
			}
			if (cl.hasOption("m")) {
				mudType = cl.getOption("m");
			}
			if (cl.hasOption("password")) {
				mudType = cl.getOption("mudtype");
			}

			if (verbose) {
				if (hostname != null) {
					System.out.println("host: "+hostname);
				}
				else {
					System.out.println("host: null");
				}
				System.out.println("port: "+port);
				if (robotName != null) {
					System.out.println("name: "+robotName);
				}
				else {
					System.out.println("name: null");
				}
				if (mudType != null) {
					System.out.println("mudType: "+mudType);
				}
				else {
					System.out.println("mudType: null");
				}
			}

		}
		catch (InvalidCommandlineArgument ica) {
			System.out.println("invalid command line argument "+ica.toString());
		}
		setInitialized(true);
	}


	public String getHostname() {
		return(this.hostname);
	}

	public int getPort() {
		return(this.port);
	}

	public String getRobotName() {
		return(this.robotName);
	}

	public String getMudType() {
		return(this.mudType);
	}

	Connection loadConnection() {
		CommandsClassLoader	loader         = null;
		String			className      = null;
		Class			c              = null;
		Object			o              = null;
		StringBuffer		connectionsPath = null;
		Connection		mudConnection   = null;

		try {
			connectionsPath = new StringBuffer();
			connectionsPath.append("plugins").append(File.separator).append("connections");
			loader = new CommandsClassLoader(connectionsPath.toString());
			className = getMudType() + "Connection";
			System.out.println(className);
			c = loader.loadClass(className, true);
			o = c.newInstance();
			mudConnection = (Connection)o;
		}
		catch(ClassNotFoundException cnfe) {
			System.out.println(cnfe.toString());
		}
		catch(IllegalAccessException iae) {
			System.out.println(iae.toString());
		}
		catch(InstantiationException ie) {
			System.out.println(ie.toString());
		}

		mudConnection.setHostname(getHostname());
		mudConnection.setPort(getPort());
		mudConnection.setRobotName(getRobotName());
		return(mudConnection);
	}

	public void run() throws OSProcessDone {
		Connection	connection = null;

		connection = loadConnection();
		registerObject("RobotConnection", connection);
		throw new OSProcessDone();
	}
}
