/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
import java.io.*;
import java.util.*;
import os.*;
import mstar.*;
import org.place.pj.*;

/**
  * A Bot OS program for handling player interaction in the collaborative
  * environment.
  *
  * @author Thaddeus O. Cooper (cooper@tweenproject.org)
  * @version 1.0
  */
public class Respond extends OSProcess {
	static final String	DEFAULT_ROBOT_PROPERTIES_FILENAME = "robot.properties";
	static final int	STANDARD_TIME_INTERVAL            = 10000;
	static final int	WAITING_TIME_INTERVAL             = 60000;
	Connection		mudConnection                     = null;
	Commands		commands                          = null;
	Responder[]		responders                        = null;
	int			state                             = 0;
	Vector			chatterVector                     = null;
	MudMap			map                               = null;
	ParseRoomDescription	roomParser                        = null;
	ProcessTable		processTable                      = null;
	GregorianCalendar	whenCanMove                       = null;
	int			waitTimeInterval                  = STANDARD_TIME_INTERVAL;
	int			responseWaitTimeInterval          = WAITING_TIME_INTERVAL;
	boolean			verbose                           = false;
	String			owner                             = null;
	ChatterFilter		chatterFilter                     = null;
	String			robotName                         = null;
	PlayerMap		playerMap                         = null;
	int			responderState                    = 0;
	Properties		properties                        = null;

	public void initialize() {
		String[]	args = null;
		Commandline	cl = null;
		//Properties	properties = null;
		String		longOptions[] = {
							"name",
							"owner",
							"properties",
							"waittime",
							"responsewaittime",
						};
		String		longFlags[] = {
						"explore",
						"verbose",
					      };
		String		fallbackExitString = null;
		FileInputStream	in                 = null;
		String		waitTimeIntervalString = null;
		String		responseWaitTimeIntervalString = null;

		args = getArgs();
		try {
			cl = new Commandline(args,
					     "nowrv",
					     "",
					     longFlags,
					     longOptions);
			// first things first, see if there is a
			// properties file that was specified
			if (cl.hasOption("properties")) {
				try {
					in = new FileInputStream(cl.getOption("properties"));
					properties = new Properties();
					properties.load(in);
				}
				catch (IOException ioe) {
					System.out.println("Properties file '"+
							   cl.getOption("properties")+
							   "' not found.");
					System.exit(-1);
				}
			}
			else {
				try {
					// first look in the local directory...
					in = new FileInputStream(System.getProperty("user.dir")+
								 File.separator+DEFAULT_ROBOT_PROPERTIES_FILENAME);
					properties = new Properties();
					properties.load(in);
				}
				catch (IOException ioe) {
					try {
						// now try the home directory....
						in = new FileInputStream(System.getProperty("user.home")+
									 File.separator+DEFAULT_ROBOT_PROPERTIES_FILENAME);
						properties = new Properties();
						properties.load(in);
					}
					catch (IOException ioe1) {
					}
				}
			}
			if (properties != null) {
				verbose = properties.getProperty("asc.verbose", "false").toLowerCase().equals("true") ? true : false;	
				waitTimeIntervalString = properties.getProperty("robot.waittimeinterval");
				if (waitTimeIntervalString != null) {
					try {
						waitTimeInterval = Integer.parseInt(waitTimeIntervalString);
					}
					catch(NumberFormatException nfe) {
						System.out.println(nfe.toString());
					}
				}
				responseWaitTimeIntervalString = properties.getProperty("robot.responsewaittimeinterval");
				if (responseWaitTimeIntervalString != null) {
					try {
						responseWaitTimeInterval = Integer.parseInt(responseWaitTimeIntervalString);
					}
					catch(NumberFormatException nfe) {
						System.out.println(nfe.toString());
					}
				}
				setRobotName(properties.getProperty("robot.name"));
				setOwner(properties.getProperty("robot.owner"));
			}

			if (cl.hasOption("v")) {
				verbose = true;
			}
			if (cl.hasOption("verbose")) {
				verbose = true;
			}
			if (cl.hasOption("w")) {
				waitTimeIntervalString = cl.getOption("w");
				if (waitTimeIntervalString != null) {
					try {
						waitTimeInterval = Integer.parseInt(waitTimeIntervalString);
					}
					catch(NumberFormatException nfe) {
						System.out.println(nfe.toString());
					}
				}
			}
			if (cl.hasOption("waittime")) {
				waitTimeIntervalString = cl.getOption("waittime");
				if (waitTimeIntervalString != null) {
					try {
						waitTimeInterval = Integer.parseInt(waitTimeIntervalString);
					}
					catch(NumberFormatException nfe) {
						System.out.println(nfe.toString());
					}
				}
			}
			if (cl.hasOption("r")) {
				responseWaitTimeIntervalString = cl.getOption("r");
				if (responseWaitTimeIntervalString != null) {
					try {
						responseWaitTimeInterval = Integer.parseInt(responseWaitTimeIntervalString);
					}
					catch(NumberFormatException nfe) {
						System.out.println(nfe.toString());
					}
				}
			}
			if (cl.hasOption("responsewaittime")) {
				responseWaitTimeIntervalString = cl.getOption("responsewaittime");
				if (responseWaitTimeIntervalString != null) {
					try {
						responseWaitTimeInterval = Integer.parseInt(responseWaitTimeIntervalString);
					}
					catch(NumberFormatException nfe) {
						System.out.println(nfe.toString());
					}
				}
			}
			if (cl.hasOption("n")) {
				setRobotName(cl.getOption("n"));
			}
			if (cl.hasOption("name")) {
				setRobotName(cl.getOption("name"));
			}
			if (cl.hasOption("o")) {
				setOwner(cl.getOption("o"));
			}
			if (cl.hasOption("owner")) {
				setOwner(cl.getOption("owner"));
			}

			if (verbose) {
				System.out.println("Respond -- waittime: "+waitTimeInterval);
				System.out.println("Respond -- responsewaittime: "+responseWaitTimeInterval);
				System.out.println("Respond -- owner: "+getOwner());
			}

		}
		catch (InvalidCommandlineArgument ica) {
			System.out.println("invalid command line argument "+ica.toString());
		}
		//chatterFilter = new TweenChatterFilter(getRobotName());
		//chatterFilter.setRobotName(getRobotName());
		chatterFilter = loadChatterFilter(getRobotName());
		if (chatterFilter == null) {
			chatterFilter = loadChatterFilter("default");
		}
		chatterFilter.setProperties(this.properties);
		chatterFilter.initialize(getRobotName());
if (this.properties == null) System.out.println("properties were null");
		if (mudConnection == null) {
			mudConnection = (Connection)requestObject("RobotConnection");
		}
		if (commands == null) {
			commands = (Commands)requestObject("RobotCommands");
		}
		if (responders == null) {
			responders = (Responder[])requestObject("RobotResponders");
		}
		if (map == null) {
			map = (MudMap)requestObject("MudMap");
		}
		if (playerMap == null) {
			playerMap = (PlayerMap)requestObject("PlayerMap");
			if (playerMap == null) {
				playerMap = new PlayerMap();
				registerObject("PlayerMap", playerMap);
			}
		}
		if (roomParser == null) {
			roomParser = (ParseRoomDescription)requestObject("RoomDescriptionParser");
		}
/*******8
		if (processTable == null) {
			processTable = (ProcessTable)requestObject("ProcessTable");
		}
*********/
		if ((mudConnection != null) &&
		    (commands != null) &&
		    (responders != null) &&
		    (map != null) &&
		    (playerMap != null) &&
		    (roomParser != null)) {
		    //(processTable != null)) {
			whenCanMove = new GregorianCalendar();
			whenCanMove.clear(Calendar.MILLISECOND);
			whenCanMove.add(Calendar.MILLISECOND, waitTimeInterval);
			registerObject("WhenCanMove", whenCanMove);
			setInitialized(true);
System.out.println("Respond has initialized");
		}
	}

	public void run() throws OSProcessRelinquishControl {
		Vector	chatterVector = null;
		boolean	responded     = false;
		//String	aLine         = null;
		Chatter	aLine         = null;

		//mudConnection.drainConnection();
		chatterVector = mudConnection.getChatterVector();
		if (chatterVector != null) {
			while (chatterVector.size() > 0) {
				//aLine = (String)chatterVector.firstElement();
				aLine = (Chatter)chatterVector.firstElement();
				//if (chatterFilter.accept(aLine)) {
if (aLine == null)  System.out.println("aLine was null"); else System.out.println(aLine.getWhat());
				//if (chatterFilter.accept(aLine.getWhat())) {
				if (chatterFilter.accept(aLine)) {
System.out.print("CHATTER FILTER ACCEPTED INPUT");
					responded = true;
					//sendResponse((String)chatterVector.firstElement());
					sendResponse(aLine);
				}
				if (chatterVector.size() > 0) {
					chatterVector.remove(0);
				}
			}
		}
		if (responded) {
			whenCanMove.clear(Calendar.MILLISECOND);
			whenCanMove.add(Calendar.MILLISECOND, responseWaitTimeInterval);
		}
		throw new OSProcessRelinquishControl();
	}

	ChatterFilter loadChatterFilter(String name) {
		ChatterFilterClassLoader	loader         = null;
		String				className      = null;
		Class				c              = null;
		Object				o              = null;
		StringBuffer			commandsPath   = null;
		ChatterFilter			chatterFilter  = null;

		try {
			commandsPath = new StringBuffer();
			commandsPath.append("plugins").append(File.separator).append("chatterfilters");
			loader = new ChatterFilterClassLoader(commandsPath.toString());
if (loader == null) System.exit(-1);
			className = name + "ChatterFilter";
System.out.println("loading: '"+className+"'");
			c = loader.loadClass(className, true);
			o = c.newInstance();
			chatterFilter = (ChatterFilter)o;
		}
		catch(ClassNotFoundException cnfe) {
			System.out.println(cnfe.toString());
		}
		catch(IllegalAccessException iae) {
			System.out.println(iae.toString());
		}
		catch(InstantiationException ie) {
			System.out.println(ie.toString());
		}
		return(chatterFilter);
	}

	void returnByPaging(String who, String response) {
		int	position = 0;

		if (response.length() > 400) {
			position = 0;
			while (position < response.length()) {
				if ((position + 400) < response.length()) {
					commands.page(who, response.substring(position, 
									position + 400));
					mudConnection.drainConnectionToSuffix();
					addChatter(mudConnection.getChatterVector());
					mudConnection.clearChatterVector();
				}
				else {
					commands.page(who, response.substring(position));
					mudConnection.drainConnectionToSuffix();
					addChatter(mudConnection.getChatterVector());
					mudConnection.clearChatterVector();
				}
				position += 400;
			}
		}
		else {
			commands.page(who, response);
			mudConnection.drainConnectionToSuffix();
			addChatter(mudConnection.getChatterVector());
			mudConnection.clearChatterVector();
		}
	}

	void returnBySaying(String response) {
		int	position = 0;

		if (response.length() > 400) {
			while (position < response.length()) {
				if ((position + 400) < response.length()) {
					commands.say(response.substring(position, 
					    position + 400));
					mudConnection.drainConnectionToSuffix();
					addChatter(mudConnection.getChatterVector());
					mudConnection.clearChatterVector();
				}
				else {
					commands.say(response.substring(position));
					mudConnection.drainConnectionToSuffix();
					addChatter(mudConnection.getChatterVector());
					mudConnection.clearChatterVector();
				}
				position += 400;
			}
		}
		else {
			commands.say(response);
			mudConnection.drainConnectionToSuffix();
			addChatter(mudConnection.getChatterVector());
			mudConnection.clearChatterVector();
		}
	}

	void returnByWhispering(String who, String response) {
		int	position = 0;

		if (response.length() > 400) {
			while (position < response.length()) {
				if ((position + 400) < response.length()) {
					commands.whisper(who, response.substring(position, 
									   position + 400));
					mudConnection.drainConnectionToSuffix();
					addChatter(mudConnection.getChatterVector());
					mudConnection.clearChatterVector();
				}
				else {
					commands.whisper(who, response.substring(position));
					mudConnection.drainConnectionToSuffix();
					addChatter(mudConnection.getChatterVector());
					mudConnection.clearChatterVector();
				}
				position += 400;
			}
		}
		else {
			commands.whisper(who, response);
			mudConnection.drainConnectionToSuffix();
			addChatter(mudConnection.getChatterVector());
			mudConnection.clearChatterVector();
		}
	}

	void returnByEmoting(String who, String response) {
		int	position = 0;

		if (response.length() > 400) {
			while (position < response.length()) {
				if ((position + 400) < response.length()) {
					commands.emote(who, response.substring(position, 
									   position + 400));
					mudConnection.drainConnectionToSuffix();
					addChatter(mudConnection.getChatterVector());
					mudConnection.clearChatterVector();
				}
				else {
					commands.emote(who, response.substring(position));
					mudConnection.drainConnectionToSuffix();
					addChatter(mudConnection.getChatterVector());
					mudConnection.clearChatterVector();
				}
				position += 400;
			}
		}
		else {
			commands.emote(who, response);
			mudConnection.drainConnectionToSuffix();
			addChatter(mudConnection.getChatterVector());
			mudConnection.clearChatterVector();
		}
	}

	void returnByMuttering(String who, String response) {
		int	position = 0;

		if (response.length() > 400) {
			while (position < response.length()) {
				if ((position + 400) < response.length()) {
					commands.mutter(who, response.substring(position, 
									   position + 400));
					mudConnection.drainConnectionToSuffix();
					addChatter(mudConnection.getChatterVector());
					mudConnection.clearChatterVector();
				}
				else {
					commands.mutter(who, response.substring(position));
					mudConnection.drainConnectionToSuffix();
					addChatter(mudConnection.getChatterVector());
					mudConnection.clearChatterVector();
				}
				position += 400;
			}
		}
		else {
			commands.mutter(who, response);
			mudConnection.drainConnectionToSuffix();
			addChatter(mudConnection.getChatterVector());
			mudConnection.clearChatterVector();
		}
	}

	/**
	  */
	//void sendResponse(String aLine) {
	void sendResponse(Chatter aLine) {
		//StringTokenizer	st    = new StringTokenizer(aLine);
		Vector				v            = new Vector();
		String				token        = null;
		String				ary[]        = null;
		String				contentAry[] = null;
		//Room				theRoom      = null;
		Stack				s            = null;
		Stack				dirs         = null;
		String				directions   = null;
		Vector				rooms        = null;
		int				i;
		int				length;
		String				stringDocument = null;
		boolean				done           = false;
		String				response       = null;
		int				position       = 0;
		//RE				re             = null;
		//REMatch				rem            = null;
		String				how            = null;
		String				who            = null;
		String				what           = null;
		RobotAction			actions[]      = null;
		int				j              = 0;
		MudPlayer			player         = null;
		StringBuffer			description    = null;

/**************
//System.out.println("processing: '"+aLine+"'");
		//while (st.hasMoreTokens()) {
//System.out.println("processing: '"+aLine+"'");
		while (st.hasMoreTokens()) {
			token = st.nextToken();
			v.addElement(token);
		}
		ary = new String[v.size()];
		v.copyInto(ary);
		// now that we have it in an array we can
		// work with it...
	who = ary[0];
	how = ary[1];
***************/
	who = aLine.getWho();
	what = aLine.getWhat();
if (!done) {
	System.out.println("about to process");
	System.out.println("aLine "+aLine.getWhat());
	System.out.println("who  "+who);
	System.out.println("what "+what);
	//System.out.println("how  "+how);
}
		i = 0;
		while ((i < responders.length) && (!done)) {
			responders[i].setCommands(commands);
			//done = responders[i].canProcess(aLine);
System.out.println("Checking "+responders[i].serviceType());
System.out.println("setting owner to: '"+getOwner()+"'");
				responders[i].setOwner(getOwner());
			done = responders[i].canProcess(aLine);
			if (done) {
System.out.println("service "+i+" claims to handle this service request.");
System.out.println("service is: "+responders[i].serviceType());
				//responders[i].setProperties(this.getProperties());
				responders[i].setProperties(this.properties);
				responders[i].setMap(map);
				responders[i].setPlayerMap(this.playerMap);
				responders[i].setWho(who);
				responders[i].setHow(how);
				//responders[i].setCurrentRoom(this.thisRoom);
				//responders[i].setCurrentRoom(this.map.getCurrentRoom());
				responders[i].setRoomParser(roomParser);
				responders[i].setConnection(mudConnection);
				//responders[i].setCommands(commands);
				responders[i].setProcessTable(processTable);
//System.out.println("setting owner to: '"+getOwner()+"'");
//				responders[i].setOwner(getOwner());
				responders[i].process();
				responders[i].setState(responderState);
				//response = responders[i].getResponse();
				actions = responders[i].getActions();
				for (j = 0; ((actions != null) && (j < actions.length)); j++) {
					response = actions[j].getResponse();
					if ((response != null) && (!response.equals(""))) {
//System.out.println("response was not null -- '"+response+"'");
//System.out.println("response was not null -- '"+actions[j].getAction()+"'");
						if (actions[j].shouldUseDefaultAction()) {
System.out.println("Should use default action");
System.out.println("how = "+aLine.getHow());
							//if (how.toLowerCase().startsWith("pages:")) {
							if (aLine.getHow() == Chatter.PAGES) {
								returnByPaging(aLine.getWho(), response);
							}
							//else if ((!how.toLowerCase().startsWith("pages:"))  &&
							//	 (!how.toLowerCase().startsWith("whispers"))) {
							else if (aLine.getHow() == Chatter.SAYS) {
								returnBySaying(response);
							}
							//else if (how.toLowerCase().startsWith("whispers")) {
							else if (aLine.getHow() == Chatter.WHISPERS) {
								returnByWhispering(aLine.getWho(), response);
							}
							else if (aLine.getHow() == Chatter.POSES) {
								returnBySaying(response);
							}
							else if (aLine.getHow() == Chatter.GIVES_OBJECT) {
								returnBySaying(response);
							}
							else if (aLine.getHow() == Chatter.EMOTES) {
								returnByEmoting(aLine.getWho(), response);
							}
						}
						else {
System.out.println("Should not use default action");
							if (actions[j].getAction().toLowerCase().startsWith("emote")) {
									returnByEmoting(aLine.getWho(), response);
									//commands.emote(ary[0], response);
									//mudConnection.drainConnectionToSuffix();
									//addChatter(mudConnection.getChatterVector());
									//mudConnection.clearChatterVector();
							}
							else if (actions[j].getAction().toLowerCase().startsWith("mutter")) {
									returnByMuttering(ary[0], response);
									//commands.mutter(ary[0], response);
									//mudConnection.drainConnectionToSuffix();
									//addChatter(mudConnection.getChatterVector());
									//mudConnection.clearChatterVector();
							}
							else if (actions[j].getAction().toLowerCase().startsWith("pages")) {
								returnByPaging(aLine.getWho(), response);
							}
							else if (actions[j].getAction().toLowerCase().startsWith("whispers")) {
								returnByWhispering(aLine.getWho(), response);
							}
							else if (actions[j].getAction().toLowerCase().startsWith("set")) {
//System.out.println("response for set was: '"+response+"'");
								commands.getOutputStream().println("@set "+response);
								mudConnection.drainConnectionToSuffix();
							}
							else if (actions[j].getAction().toLowerCase().startsWith("go")) {
//System.out.println("response for go was: '"+response+"'");
								//commands.getOutputStream().println("go "+response);
								commands.go(response);
								mudConnection.drainConnectionToSuffix();
							}
							//else if ((!how.toLowerCase().startsWith("pages:"))  &&
							//	 (!how.toLowerCase().startsWith("whispers"))) {
							else if ((aLine.getHow() != Chatter.PAGES)  && (aLine.getHow() != Chatter.WHISPERS)) {
								if (actions[j].getAction().toLowerCase().startsWith("pose")) {
										commands.pose(response);
										mudConnection.drainConnectionToSuffix();
										addChatter(mudConnection.getChatterVector());
										mudConnection.clearChatterVector();
								}
								else if ((!actions[j].getAction().toLowerCase().startsWith("pages"))  &&
								 	(!actions[j].getAction().toLowerCase().startsWith("whispers"))) {
									returnBySaying(response);
								}
							}
							//else if ((how.toLowerCase().startsWith("pages:")) &&
							else if ((aLine.getHow() == Chatter.PAGES) &&
									   (actions[j].getAction().toLowerCase().startsWith("pose"))) {
									//commands.emote(ary[0], response);
									returnByEmoting(aLine.getWho(), response);
									//commands.emote(aLine.getWho(), response);
									//mudConnection.drainConnectionToSuffix();
									//addChatter(mudConnection.getChatterVector());
									//mudConnection.clearChatterVector();
							}
						}
					}
				}
				responderState = responders[i].getState();
				//else if ((responders[i].getAction() != null) &&
			}
			else {
				i++;
			}
		}
	}

	public void addChatter(Vector cv) {
		int	i;
		int	length;

		if (cv != null) {
			length = cv.size();
			for (i = 0; i < length; i++) {
				if (chatterVector == null) {
					chatterVector = new Vector();
				}
				chatterVector.add(cv.elementAt(i));
			}
		}
	}

	public void setOwner(String owner) {
		this.owner = owner;
	}

	public String getOwner() {
		return(this.owner);
	}

	public void setRobotName(String robotName) {
		this.robotName = robotName;
	}

	public String getRobotName() {
		return(this.robotName);
	}
}
