/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
import java.io.*;
import os.*;
import mstar.*;

/**
  * A Bot OS program that implements the Simple Bot Scripting Language (SBSL).
  * The language is very simple. Each line of a script (.scr file) can either
  * be a comment (it starts with a # in column 1) or a command. Commands can
  * have arguments which are space separated on the line. If a string of space
  * separated words needs to be treated as a single argument, then they may
  * be quoted with double quotes (&quot;). Commands can also run in the 
  * foreground or the background. A program that is to run as a background
  * process ends with an ampersand (&amp;).
  *
  * @author Thaddeus O. Cooper (cooper@tweenproject.org)
  * @version 1.0
  */
public class sbsl extends OSProcess {
	boolean		dontBother = false;
	BufferedReader	br         = null;

	public void initialize() {
		String	args[] = null;
		int	i;

		args = getArgs();
System.out.println("args are: ");
for (i = 0; i < args.length; i++) {
	System.out.println(args[i]);
}
		if (getArgs().length < 2) {
			System.out.println("nothing to run...");
			dontBother = true;
		}
		else {
			// set up the file...
			try {
				args = getArgs();
				br = new BufferedReader(new FileReader("processes/"+args[1]+".scr"));
			}
			catch(FileNotFoundException fnf) {
				System.out.println("sbsl "+fnf.toString());
			}
			catch(IOException ioe) {
				System.out.println("sbsl "+ioe.toString());
			}
		}
		setInitialized(true);
	}

	public void run() throws OSProcessRelinquishControl,
				 OSProcessLoadProcess,
				 OSProcessExecProcess,
				 OSProcessWaitForProcess,
				 OSProcessDone {
		String	aLine = null;

		if (dontBother) {
			throw new OSProcessDone();
		}
		else {
			if (br != null) {
				try {
					aLine = br.readLine();
					if (aLine != null) {
						if (!aLine.startsWith("#")) {
							if (aLine.trim().endsWith("&")) {
								throw new OSProcessLoadProcess(aLine);
							}
							else {
								throw new OSProcessWaitForProcess(aLine);
							}
						}
						else {
							throw new OSProcessRelinquishControl();
						}
					}
					else {
						throw new OSProcessDone();
					}
				}
				catch(IOException ioe) {
					System.out.println(ioe.toString());
				}
			}
		}
	}
}
