/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
import java.io.*;
import java.util.*;
import os.*;
import org.place.pj.*;

public class tween {
	static final String	DEFAULT_ROBOT_PROPERTIES_FILENAME = "robot.properties";

	public static void main(String[] args) {
		OSScheduler	oss = null;
		Commandline	cl = null;
		boolean		verbose = false;
		String		longOptions[] = {
							"processesdirectory",
							"initprocess",
							"properties",
						};
		String		longFlags[] = {
						"verbose",
					      };
		Properties	properties = null;
		FileInputStream	in         = null;
		String		processesDirectory    = null;
		String		initializationProcess = null;

		try {
			cl = new Commandline(args,
					     "piPv",
					     "",
					     longFlags,
					     longOptions);
			// first things first, see if there is a
			// properties file that was specified
			if (cl.hasOption("properties")) {
				try {
					in = new FileInputStream(cl.getOption("properties"));
					properties = new Properties();
					properties.load(in);
				}
				catch (IOException ioe) {
					System.out.println("Properties file '"+
							   cl.getOption("properties")+
							   "' not found.");
					System.exit(-1);
				}
			}
			else {
				try {
					// first look in the local directory...
					in = new FileInputStream(System.getProperty("user.dir")+
								 File.separator+DEFAULT_ROBOT_PROPERTIES_FILENAME);
					properties = new Properties();
					properties.load(in);
				}
				catch (IOException ioe) {
					try {
						// now try the home directory....
						in = new FileInputStream(System.getProperty("user.home")+
									 File.separator+DEFAULT_ROBOT_PROPERTIES_FILENAME);
						properties = new Properties();
						properties.load(in);
					}
					catch (IOException ioe1) {
					}
				}
			}
			if (properties != null) {
				verbose = properties.getProperty("asc.verbose", "false").toLowerCase().equals("true") ? true : false;	
				processesDirectory    = properties.getProperty("robot.processesdirectory", "processes/");
				initializationProcess = properties.getProperty("robot.initializationprocess", "initialize");
			}

			if (cl.hasOption("v")) {
				verbose = true;
			}
			if (cl.hasOption("verbose")) {
				verbose = true;
			}
			if (cl.hasOption("i")) {
				initializationProcess = cl.getOption("i");
			}
			if (cl.hasOption("initprocess")) {
				initializationProcess = cl.getOption("initprocess");
			}
			if (cl.hasOption("P")) {
				processesDirectory = cl.getOption("P");
			}
			if (cl.hasOption("processesdirectory")) {
				processesDirectory = cl.getOption("processesdirectory");
			}

			if (verbose) {
				System.out.println("processesDirectory: "+processesDirectory);
				System.out.println("initializationProcess: "+initializationProcess);
			}

		}
		catch (InvalidCommandlineArgument ica) {
			System.out.println("invalid command line argument "+ica.toString());
		}
		//oss = new OSScheduler("./processes/", "initialize");
		oss = new OSScheduler(processesDirectory, initializationProcess);
		oss.start();
	}
}
