/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */

package util;

import java.util.StringTokenizer;
import java.util.Vector;

public class KeyValue {
	String	key = "";
	boolean	booleanValue = false;
	char	charValue    = '\u0000';
	byte	byteValue    = (byte)0;
	short	shortValue   = (short)0;
	int	intValue     = 0;
	long	longValue    = (long)0;
	float	floatValue   = (float)0.0;
	double	doubleValue  = 0.0;
	String	stringValue  = "";
	int	type         = 0;
	Object	objectValue  = null;

	public static final int BOOLEAN	=   1;
	public static final int CHAR	=   2;
	public static final int BYTE	=   4;
	public static final int SHORT	=   8;
	public static final int INT	=  16;
	public static final int LONG	=  32;
	public static final int FLOAT	=  64;
	public static final int DOUBLE	= 128;
	public static final int STRING	= 256;
	public static final int OBJECT	= 512;
	
	public KeyValue(String theKey, boolean theValue)
	{
		type = BOOLEAN;
		key = theKey;
		booleanValue = theValue;
	}

	public KeyValue(String theKey, char theValue)
	{
		type = CHAR;
		key = theKey;
		charValue = theValue;
	}

	public KeyValue(String theKey, byte theValue)
	{
		type = BYTE;
		key = theKey;
		byteValue = theValue;
	}

	public KeyValue(String theKey, short theValue)
	{
		type = SHORT;
		key = theKey;
		shortValue = theValue;
	}

	public KeyValue(String theKey, int theValue)
	{
		type = INT;
		key = theKey;
		intValue = theValue;
	}

	public KeyValue(String theKey, long theValue)
	{
		type = LONG;
		key = theKey;
		longValue = theValue;
	}

	public KeyValue(String theKey, float theValue)
	{
		type = FLOAT;
		key = theKey;
		floatValue = theValue;
	}

	public KeyValue(String theKey, double theValue)
	{
		type = DOUBLE;
		key = theKey;
		doubleValue = theValue;
	}

	public KeyValue(String theKey, String theValue)
	{
		type = STRING;
		key = theKey;
		stringValue = translateString(theValue);
	}

	public KeyValue(String theKey, Object theValue)
	{
		type        = OBJECT;
		key         = theKey;
		objectValue = theValue;
	}

	String translateString(String s)
	{
		int	i;
		StringBuffer	buffer = new StringBuffer();

		i = 0;
    		int len = s.length();
		while (i < len) {
			if (s.charAt(i) == '\\') {
				i++;
				if (s.charAt(i) == 'n') {
					buffer.append("\n");
				}
				else if (s.charAt(i) == 't') {
					buffer.append("\t");
				}
				else {
					buffer.append(s.charAt(i));
				}
			}
			else {
				buffer.append(s.charAt(i));
			}
			i++;
		}
		return(buffer.toString());
	}

	public String getKey()
	{
		return(key);
	}

	public boolean getBoolean()
	{
		return(booleanValue);
	}

	public char getChar()
	{
		return(charValue);
	}

	public byte getByte()
	{
		return(byteValue);
	}

	public short getShort()
	{
		return(shortValue);
	}

	public int getInt()
	{
		return(intValue);
	}

	public long getLong()
	{
		return(longValue);
	}

	public float getFloat()
	{
		return(floatValue);
	}

	public double getDouble()
	{
		return(doubleValue);
	}

	public String getString()
	{
		return(stringValue);
	}

	public int getType()
	{
		return(type);
	}

	public Object getObject()
	{
		return(objectValue);
	}

	public boolean isBoolean()
	{
		return(type == BOOLEAN);
	}

	public boolean isChar()
	{
		return(type == CHAR);
	}

	public boolean isByte()
	{
		return(type == BYTE);
	}

	public boolean isShort()
	{
		return(type == SHORT);
	}

	public boolean isInt()
	{
		return(type == INT);
	}

	public boolean isLong()
	{
		return(type == LONG);
	}

	public boolean isFloat()
	{
		return(type == FLOAT);
	}

	public boolean isDouble()
	{
		return(type == DOUBLE);
	}

	public boolean isString()
	{
		return(type == STRING);
	}

	public boolean isObject()
	{
		return(type == OBJECT);
	}

	public void setKey(String s)
	{
		key = s;
	}

	public void set(boolean value)
	{
		if (isBoolean()) {
			booleanValue = value;
		}
	}

	public void set(char value)
	{
		if (isChar()) {
			charValue = value;
		}
	}

	public void set(byte value)
	{
		if (isByte()) {
			byteValue = value;
		}
	}

	public void set(short value)
	{
		if (isShort()) {
			shortValue = value;
		}
	}

	public void set(int value)
	{
		if (isInt()) {
			intValue = value;
		}
	}

	public void set(long value)
	{
		if (isLong()) {
			longValue = value;
		}
	}

	public void set(float value)
	{
		if (isFloat()) {
			floatValue = value;
		}
	}

	public void set(double value)
	{
		if (isDouble()) {
			doubleValue = value;
		}
	}

	public void set(String value)
	{
		if (isString()) {
			stringValue = value;
		}
	}

	public void set(Object value)
	{
		if (isObject()) {
			objectValue = value;
		}
	}

	public String toString()
	{
		String	buffer = "";

		buffer = key + ":";
		if (isBoolean()) {
			buffer = buffer + String.valueOf(booleanValue);
		}
		else if (isChar()) {
			buffer = buffer + String.valueOf(charValue);
		}
		else if (isByte()) {
			buffer = buffer + String.valueOf(byteValue);
		}
		else if (isShort()) {
			buffer = buffer + String.valueOf(shortValue);
		}
		else if (isInt()) {
			buffer = buffer + String.valueOf(intValue);
		}
		else if (isLong()) {
			buffer = buffer + String.valueOf(longValue);
		}
		else if (isFloat()) {
			buffer = buffer + String.valueOf(floatValue);
		}
		else if (isDouble()) {
			buffer = buffer + String.valueOf(doubleValue);
		}
		else if (isString()) {
			buffer = buffer + escapeString(stringValue);
		}
		else if (isObject()) {
			buffer = buffer + String.valueOf(objectValue.toString());
		}
		return(buffer);
	}

	private String escapeString (String s)
	{
		StringBuffer buffer = new StringBuffer();
		int	i;
		int len = s.length();

		for (i = 0; i < len; i++) {
			if (s.charAt(i) == '\n') {
				buffer.append("\\\\n");
			}
			else if (s.charAt(i) == '\t') {
				buffer.append("\\\\t");
			}
			else {
				buffer.append(s.charAt(i));
			}
		}
		return(buffer.toString());
	}

	public static KeyValue[] toKeyValues(String s)
	{
		StringTokenizer	crST;
		String		token;
		String		fieldName;
		String		value;
		Vector		vector;
		KeyValue	aKeyValue;
		KeyValue[]	keyValues;
		int		i;

		vector = new Vector();
		crST   = new StringTokenizer(s, "\n");
		token  = crST.nextToken();
		while (crST.hasMoreTokens()) {
			i = token.indexOf(':');
			if (i != -1) {
				fieldName = token.substring(0, i);
				i++;
				value     = token.substring(i);
				aKeyValue = new KeyValue(fieldName, value);
				vector.addElement(aKeyValue);
			}
			token = crST.nextToken();
		}
		i = token.indexOf(':');
		if (i != -1) {
			fieldName = token.substring(0, i);
			i++;
			value     = token.substring(i);
			aKeyValue = new KeyValue(fieldName, value);
			vector.addElement(aKeyValue);
		}
		keyValues = new KeyValue[vector.size()];
		vector.copyInto(keyValues);
		return(keyValues);
	}
}
