/*
 * Decompiled with CFR 0.152.
 */
package mstar;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;

public abstract class Connection {
    static final boolean debug = true;
    String hostname = null;
    int port = 4201;
    Socket mudSocket = null;
    PrintStream out = null;
    DataInputStream in = null;
    String outputPrefix = null;
    String outputSuffix = null;
    String robotName = null;

    public Connection() {
        this.initialize(null, 4201);
    }

    public Connection(int port) {
        this.initialize(null, port);
    }

    public Connection(String hostname) {
        this.initialize(hostname, 4201);
    }

    public Connection(String hostname, int port) {
        this.initialize(hostname, port);
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public abstract void clearChatterVector();

    public void connectToMud() {
        block3: {
            if (this.getHostname() == null) break block3;
            try {
                this.mudSocket = new Socket(this.getHostname(), this.getPort());
                this.out = new PrintStream(this.mudSocket.getOutputStream());
                this.in = new DataInputStream(this.mudSocket.getInputStream());
                this.drainConnection();
            }
            catch (UnknownHostException unknownHostException) {
                System.exit(-1);
            }
            catch (IOException iOException) {
                System.exit(-1);
            }
        }
    }

    public void drainConnection() {
        this.drainConnection(true);
    }

    public abstract void drainConnection(boolean var1);

    public void drainConnectionToSuffix() {
        this.drainConnectionToSuffix(true);
    }

    public abstract void drainConnectionToSuffix(boolean var1);

    public abstract void findOutputPrefix();

    public abstract Vector getChatterVector();

    public String getHostname() {
        return this.hostname;
    }

    public DataInputStream getInputStream() {
        return this.in;
    }

    public String getOutputPrefix() {
        return this.outputPrefix;
    }

    public PrintStream getOutputStream() {
        return this.out;
    }

    public String getOutputSuffix() {
        return this.outputSuffix;
    }

    public int getPort() {
        return this.port;
    }

    public String getRobotName() {
        return this.robotName;
    }

    void initialize(String hostname, int port) {
        this.setHostname(hostname);
        this.setPort(port);
    }

    public abstract void logOffMud();

    public abstract void loginToMud(String var1, String var2);

    public String readLine() throws IOException {
        return this.in.readLine();
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setOutputPrefix(String outputPrefix) {
        this.outputPrefix = outputPrefix;
    }

    public void setOutputSuffix(String outputSuffix) {
        this.outputSuffix = outputSuffix;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setRobotName(String robotName) {
        this.robotName = robotName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForData() {
        try {
            while (true) {
                if (this.available() != 0) {
                    return;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe.toString());
        }
    }
}

