/*
 * Decompiled with CFR 0.152.
 */
package mstar;

import java.io.DataInputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.Vector;
import mstar.Chatter;
import mstar.Commands;
import mstar.Connection;
import mstar.MudMap;
import mstar.ParseRoomDescription;
import mstar.PlayerMap;
import mstar.RobotAction;
import os.ProcessTable;

public abstract class Responder {
    String name = null;
    MudMap map = null;
    String who = null;
    String what = null;
    String how = null;
    String response = null;
    String action = null;
    Properties properties = null;
    PrintStream out = null;
    DataInputStream in = null;
    Vector actions = null;
    PlayerMap players = null;
    ParseRoomDescription roomParser = null;
    Commands commands = null;
    Connection connection = null;
    String owner = null;
    ProcessTable processTable = null;
    int state = 0;
    Vector shared = null;

    public Responder() {
    }

    public Responder(String name) {
        this();
        this.setRobotName(name);
    }

    public Responder(String name, MudMap map) {
        this(name);
        this.setMap(map);
    }

    public Responder(String name, MudMap map, String who) {
        this(name, map);
        this.setWho(who);
    }

    public Responder(String name, MudMap map, String who, String what) {
        this(name, map, who);
        this.setWhat(what);
    }

    public Responder(String name, MudMap map, String who, String what, DataInputStream in) {
        this(name, map, who, what);
        this.setInputStream(in);
    }

    public Responder(String name, MudMap map, String who, String what, DataInputStream in, PrintStream out) {
        this(name, map, who, what, in);
        this.setOutputStream(out);
    }

    public Responder(String name, MudMap map, String who, String what, DataInputStream in, PrintStream out, Properties properties) {
        this(name, map, who, what, in, out);
        this.setProperties(properties);
    }

    public void addAction(String how, String action) {
        this.addRobotAction(how, action);
    }

    public void addResponse(String response) {
        this.addRobotAction("DEFAULT", response);
    }

    protected void addRobotAction(String action, String response) {
        if (this.actions == null) {
            this.actions = new Vector();
        }
        this.actions.addElement(new RobotAction(action, response));
    }

    public abstract boolean canProcess(Chatter var1);

    public String getAction() {
        return this.action;
    }

    public RobotAction[] getActions() {
        Object[] actionAry = null;
        if (this.actions != null) {
            actionAry = new RobotAction[this.actions.size()];
            this.actions.copyInto(actionAry);
            this.actions.clear();
        }
        return actionAry;
    }

    public Commands getCommands() {
        return this.commands;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getHow() {
        return this.how;
    }

    public DataInputStream getInputStream() {
        return this.in;
    }

    public MudMap getMap() {
        return this.map;
    }

    public PrintStream getOutputStream() {
        return this.out;
    }

    public String getOwner() {
        return this.owner;
    }

    public PlayerMap getPlayerMap() {
        return this.players;
    }

    public ProcessTable getProcessTable() {
        return this.processTable;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getResponse() {
        return this.response;
    }

    public String getRobotName() {
        return this.name;
    }

    public ParseRoomDescription getRoomParser() {
        return this.roomParser;
    }

    public Vector getShared() {
        return this.shared;
    }

    public int getState() {
        return this.state;
    }

    public String getWhat() {
        return this.what;
    }

    public String getWho() {
        return this.who;
    }

    public abstract void process();

    public abstract String serviceType();

    public void setAction(String action) {
        this.action = action;
    }

    public void setCommands(Commands commands) {
        this.commands = commands;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setHow(String how) {
        this.how = how;
    }

    public void setInputStream(DataInputStream in) {
        this.in = in;
    }

    public void setMap(MudMap map) {
        this.map = map;
    }

    public void setOutputStream(PrintStream out) {
        this.out = out;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setPlayerMap(PlayerMap players) {
        this.players = players;
    }

    public void setProcessTable(ProcessTable processTable) {
        this.processTable = processTable;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    protected void setResponse(String response) {
        this.response = response;
    }

    public void setRobotName(String name) {
        this.name = name;
    }

    public void setRoomParser(ParseRoomDescription roomParser) {
        this.roomParser = roomParser;
    }

    public void setShared(Vector shared) {
        this.shared = shared;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setWhat(String what) {
        this.what = what;
    }

    public void setWho(String who) {
        this.who = who;
    }
}

