/*
 * Decompiled with CFR 0.152.
 */
package os;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import os.OSProcess;
import os.OSProcessDone;
import os.OSProcessExecProcess;
import os.OSProcessLoadProcess;
import os.OSProcessLoader;
import os.OSProcessRelinquishControl;
import os.OSProcessWaitForProcess;
import os.ProcessTable;
import os.Shared;

public class OSScheduler {
    ProcessTable processTable = null;
    OSProcess processToRun = null;
    int processId = 0;
    String initPath = null;
    String initProcessName = null;
    Shared kvPairs = null;
    OSProcessLoader loader = null;

    public OSScheduler() {
        this.init(null, null);
    }

    public OSScheduler(String initPath) {
        this.init(initPath, null);
    }

    public OSScheduler(String initPath, String initProcessName) {
        this.init(initPath, initProcessName);
    }

    public String getInitPath() {
        return this.initPath;
    }

    public String getInitProcessName() {
        return this.initProcessName;
    }

    String getProcessName(String processWithArgs) {
        StringTokenizer st = null;
        String processName = null;
        st = new StringTokenizer(processWithArgs);
        if (st.hasMoreTokens()) {
            processName = st.nextToken();
        }
        if (processName.endsWith("&")) {
            processName = processName.substring(0, processName.length() - 1);
        }
        return processName;
    }

    void init(String initPath, String initProcessName) {
        this.processTable = new ProcessTable();
        this.initPath = initPath;
        this.initProcessName = initProcessName;
        this.kvPairs = new Shared();
    }

    OSProcess loadProcess(String processName) {
        OSProcess newProcess = null;
        Class c = null;
        Object o = null;
        try {
            c = this.loader.loadClass(this.getProcessName(processName), true);
            o = c.newInstance();
            newProcess = o;
            newProcess.setId(++this.processId);
            newProcess.setArgs(processName);
            newProcess.setShared(this.kvPairs);
            this.processTable.addProcess(newProcess);
        }
        catch (ClassNotFoundException classNotFoundException) {
            BufferedReader br = null;
            String interpreter = null;
            String firstLine = null;
            try {
                br = new BufferedReader(new FileReader("processes/" + this.getProcessName(processName) + ".scr"));
                firstLine = br.readLine();
                if (firstLine.startsWith("#!")) {
                    interpreter = firstLine.substring(2);
                    try {
                        c = this.loader.loadClass(interpreter, true);
                        o = c.newInstance();
                        newProcess = o;
                        newProcess.setId(++this.processId);
                        newProcess.setArgs(String.valueOf(interpreter) + " " + processName);
                        newProcess.setShared(this.kvPairs);
                        this.processTable.addProcess(newProcess);
                    }
                    catch (ClassNotFoundException cnfe1) {
                        System.out.println(cnfe1.toString());
                    }
                    catch (InstantiationException ie1) {
                        System.out.println(ie1.toString());
                    }
                    catch (IllegalAccessException iae1) {
                        System.out.println(iae1.toString());
                    }
                } else {
                    System.out.println(String.valueOf(this.getProcessName(processName)) + ": Command not found.");
                }
                br.close();
            }
            catch (FileNotFoundException fnf) {
                System.out.println(fnf.toString());
            }
            catch (IOException ioe) {
                System.out.println(ioe.toString());
            }
        }
        catch (InstantiationException ie) {
            System.out.println(ie.toString());
        }
        catch (IllegalAccessException iae) {
            System.out.println(iae.toString());
        }
        return newProcess;
    }

    public static void main(String[] args) {
        OSScheduler rs = null;
        rs = new OSScheduler("./processes/", "initialize");
        rs.start();
    }

    public void setInitPath(String initPath) {
        this.initPath = initPath;
    }

    public void setInitProcessName(String initProcessName) {
        this.initProcessName = initProcessName;
    }

    public void start() {
        OSProcess initProcess = null;
        boolean done = false;
        Class c = null;
        Object o = null;
        if (this.initPath != null && this.initProcessName != null) {
            try {
                this.loader = new OSProcessLoader(this.initPath);
                c = this.loader.loadClass(this.initProcessName, true);
                o = c.newInstance();
                initProcess = o;
            }
            catch (ClassNotFoundException cnfe) {
                System.out.println(cnfe.toString());
                System.exit(-1);
            }
            catch (InstantiationException ie) {
                System.out.println(ie.toString());
                System.exit(-1);
            }
            catch (IllegalAccessException iae) {
                System.out.println(iae.toString());
                System.exit(-1);
            }
        } else {
            try {
                this.loader = new OSProcessLoader("./processes/");
                c = this.loader.loadClass("testInit", true);
                o = c.newInstance();
                initProcess = o;
            }
            catch (ClassNotFoundException cnfe) {
                System.out.println(cnfe.toString());
                System.exit(-1);
            }
            catch (InstantiationException ie) {
                System.out.println(ie.toString());
                System.exit(-1);
            }
            catch (IllegalAccessException iae) {
                System.out.println(iae.toString());
                System.exit(-1);
            }
        }
        initProcess.setId(++this.processId);
        initProcess.setShared(this.kvPairs);
        this.processTable = new ProcessTable();
        this.processTable.addProcess(initProcess);
        while (!done) {
            this.processToRun = this.processTable.getNextProcess();
            if (this.processToRun != null) {
                OSProcess newProcess;
                try {
                    if (this.processToRun.isInitialized()) {
                        if (!this.processToRun.isWaitingFor()) {
                            this.processToRun.run();
                        } else if (this.processTable.getProcess(this.processToRun.getWaitingFor()) != null) {
                            this.processTable.addProcess(this.processToRun);
                        } else {
                            this.processToRun.run();
                        }
                    } else {
                        this.processToRun.initialize();
                        this.processTable.addProcess(this.processToRun);
                    }
                }
                catch (OSProcessRelinquishControl oSProcessRelinquishControl) {
                    this.processTable.addProcess(this.processToRun);
                }
                catch (OSProcessDone oSProcessDone) {
                    this.processToRun.done();
                }
                catch (OSProcessLoadProcess rplp) {
                    newProcess = null;
                    this.processTable.addProcess(this.processToRun);
                    newProcess = this.loadProcess(rplp.getProcessToLoad());
                    newProcess.setParentId(0);
                }
                catch (OSProcessWaitForProcess rplp) {
                    newProcess = null;
                    this.processTable.addProcess(this.processToRun);
                    newProcess = this.loadProcess(rplp.getProcessToWaitFor());
                    newProcess.setParentId(this.processToRun.getId());
                    this.processToRun.setWaitingFor(this.processId);
                }
                catch (OSProcessExecProcess rplp) {
                    newProcess = null;
                    newProcess = this.loadProcess(rplp.getProcessToExec());
                    newProcess.setParentId(0);
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                    e.printStackTrace();
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (NullPointerException npe) {
                System.out.println(npe.toString());
                npe.printStackTrace();
            }
            catch (RuntimeException e) {
                System.out.println(e.toString());
                e.printStackTrace();
            }
        }
    }
}

