/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
package os;

/**
  * Thrown when a process wishes to load another process.
  *
  * @author Thaddeus O. Cooper (cooper@tweenproject.org)
  * @version 1.0
  */
public class OSProcessLoadProcess extends Exception {
	String	processToLoad = null;

	/**
	  * Create an empty exception.
	  */
	public OSProcessLoadProcess() {
		super();
	}

	/**
	  * Create an exception and specify the process to load.
	  *
	  * @param s the name of the process to load.
	  */
	public OSProcessLoadProcess(String s) {
		super();
		this.processToLoad = s;
	}

	/**
	  * Gets the name of the process to load.
	  *
	  * @return the name of the process to load.
	  */
	public String getProcessToLoad() {
		return(this.processToLoad.endsWith("&") ? this.processToLoad.substring(0, this.processToLoad.length()-1).trim() : this.processToLoad);
	}
}
