/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
package os;

import java.util.*;
import util.*;

/**
  * Implements the shared interprocess communication mechanism that is used
  * by processes in the operating system to communicate with one another.
  *
  * @author Thaddeus O. Cooper (cooper@tweenproject.org)
  * @version 1.1
  */
public class Shared extends Vector {

	/**
	  * Create an empty shared space.
	  */
	public Shared() {
		super();
	}

	/**
	  * Creates a shared space containing the elements of the specified
	  * collection, in the order they are returned by the collection's
	  * iterator.
	  *
	  * @param c the collection to be added.
	  */
	public Shared(Collection c) {
		super(c);
	}

	/**
	  * Creates an empty shared space with the specified initial capacity.
	  *
	  * @param initialCapacity the initial capacity of the shared space.
	  */
	public Shared(int initialCapacity) {
		super(initialCapacity);
	}

	/**
	  * Creates an empty shared space with the specified initial capacity,
	  * and capacity increment.
	  *
	  * @param initialCapacity the initial capacity of the shared space.
	  * @param capacityIncrement the amount by which the capacity is
	  *                          increased when the shared space overflows.
	  */
	public Shared(int initialCapacity, int capacityIncrement) {
		super(initialCapacity, capacityIncrement);
	}

	/**
	  * Finds a key value pair in a Vector of pairs.
	  *
	  * @param key the name of the key value pair to locate.
	  * @param pairs the pairs to search for the key value.
	  * @return the key value pair that was requested, or null if it does
	  *         not exist in the Vector.
	  */
	KeyValue findKeyValuePair(String key, Vector pairs) {
		int		length;
		int		i = 0;
		boolean		done = false;
		KeyValue	rc = null;
		KeyValue	thisPair = null;

		length = pairs.size();
		while ((i < length) && (!done)) {
			thisPair = (KeyValue)pairs.elementAt(i);
			if (thisPair.getKey().toLowerCase().equalsIgnoreCase(key)) {
				done = true;
				rc = thisPair;
			}
			else {
				i++;
			}
		}
		return(rc);
	}
}

