/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
import java.io.*;
import java.util.*;
import util.*;
import mstar.*;

/**
  * Implements the ParsePlayer class for TinyMud's.
  *
  * @author Thaddeus O. Cooper (cooper@tweenproject.org)
  * @version 1.0
  */
public class TinyMudParsePlayer extends ParsePlayer {
	static final boolean debug = true;
	static final char    EOS   = '\0';

	/**
	  * Parses the player data that is returned from the collaborative
	  * environment and returns a MudPlayer class that represents the
	  * player.
	  *
	  * @param s the player data from the collaborative environment that
	  *          is to be parsed.
	  * @return a MudPlayer object that represents the player.
	  */
	public MudPlayer parse(String s) {
		int		state                            = 0;
		int		i                                = 0;
		char		c;
		boolean		done                             = false;
		StringBuffer	descriptionStringBuffer          = null;
		StringBuffer	titlesAndMembershipsStringBuffer = null;
		StringBuffer	carryingStringBuffer             = null;
		MudPlayer	player                           = null;

		if ((s == null) ||
		    (s.length() == 0)) {
			done = true;
		}
		if (debug) {
			System.out.println("===> "+s);
			try{Thread.sleep(1000);}catch(InterruptedException ie){}
		}
		while (!done) {
			if (i < s.length()) {
					c = s.charAt(i);
			}
			else {
				c = EOS;
			}
			switch (state) {
				case  0 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case '\n' :
							state = 1;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							if (descriptionStringBuffer == null) {
								descriptionStringBuffer = new StringBuffer();
							}
							descriptionStringBuffer.append(c);
							i++;
							break;
					}
					break;
				case  1 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					// we at least have a player's description...
					player = new MudPlayer();
					player.setDescription(descriptionStringBuffer.toString());
					switch(c) {
						case 'C' :
						case 'c' :
							state = 30;
							i++;
							break;
						case '[' :
							state = 2;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							i++;
							break;
					}
					break;
				case  2 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case ' '  :
						case '\t' :
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 3;
							//i++;
							break;
					}
					break;
				case  3 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'T'  :
						case 't'  :
							state = 4;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  4 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'I'  :
						case 'i'  :
							state = 5;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  5 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'T'  :
						case 't'  :
							state = 6;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  6 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'L'  :
						case 'l'  :
							state = 7;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  7 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'E'  :
						case 'e'  :
							state = 8;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  8 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'S'  :
						case 's'  :
							state = 9;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  9 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case ' '  :
						case '\t' :
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 10;
							//i++;
							break;
					}
					break;
				case  10 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'A'  :
						case 'a'  :
							state = 11;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  11 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'N'  :
						case 'n'  :
							state = 12;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  12 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'D'  :
						case 'd'  :
							state = 13;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  13 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case ' '  :
						case '\t' :
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 14;
							//i++;
							break;
					}
					break;
				case  14 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'M'  :
						case 'm'  :
							state = 15;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  15 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'E'  :
						case 'e'  :
							state = 16;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  16 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'M'  :
						case 'm'  :
							state = 17;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  17 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'B'  :
						case 'b'  :
							state = 18;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  18 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'E'  :
						case 'e'  :
							state = 19;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  19 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'R'  :
						case 'r'  :
							state = 20;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  20 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'S'  :
						case 's'  :
							state = 21;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  21 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'H'  :
						case 'h'  :
							state = 22;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  22 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'I'  :
						case 'i'  :
							state = 23;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  23 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'P'  :
						case 'p'  :
							state = 24;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  24 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'S'  :
						case 's'  :
							state = 25;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  25 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case ':'  :
							state = 26;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  26 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case ' '  :
						case '\t' :
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 27;
							break;
					}
					break;
				case  27 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case ']'  :
							// we have the players titles and memberships...
							player.setTitlesAndMemberships(Utility.commaListToArray(titlesAndMembershipsStringBuffer.toString()));
							titlesAndMembershipsStringBuffer.setLength(0);
							state = 28;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							if (titlesAndMembershipsStringBuffer == null) {
								titlesAndMembershipsStringBuffer = new StringBuffer();
							}
							titlesAndMembershipsStringBuffer.append(c);
							i++;
							break;
					}
					break;
				case  28 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case '\n'  :
							state = 29;
							i++;
							break;
						case '['   :
							state = 41;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							i++;
							break;
					}
					break;
				case  29 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'C'  :
						case 'c'  :
							state = 30;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  30 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'A'  :
						case 'a'  :
							state = 31;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  31 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'R'  :
						case 'r'  :
							state = 32;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  32 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'R'  :
						case 'r'  :
							state = 33;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  33 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'Y'  :
						case 'y'  :
							state = 34;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  34 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'I'  :
						case 'i'  :
							state = 35;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  35 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'N'  :
						case 'n'  :
							state = 36;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  36 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'G'  :
						case 'g'  :
							state = 37;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  37 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case ':'  :
							state = 38;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  38 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case '\n' :
							state = 39;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  39 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case EOS :
							state = 40;
							break;
						case '\n' :
							// copy to carrying...
							if (player == null) {
								player = new MudPlayer();
							}
							player.addObject(carryingStringBuffer.toString());
							carryingStringBuffer.setLength(0);
							i++;
							break;
						default  :
							// buffer...
							if (carryingStringBuffer == null) {
								carryingStringBuffer = new StringBuffer();
							}
							carryingStringBuffer.append(c);
							i++;
							break;
					}
					break;
				case  40 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case EOS :
							done = true;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  41 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case ' '  :
						case '\t' :
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 42;
							break;
					}
					break;
				case  42 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'C' :
						case 'c' :
							state = 43;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  43 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'O' :
						case 'o' :
							state = 44;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  44 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'N' :
						case 'n' :
							state = 45;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  45 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'T' :
						case 't' :
							state = 46;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  46 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'I' :
						case 'i' :
							state = 47;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  47 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'N' :
						case 'n' :
							state = 48;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  48 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'U' :
						case 'u' :
							state = 49;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  49 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'E' :
						case 'e' :
							state = 50;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  50 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case 'D' :
						case 'd' :
							state = 51;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  51 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case ':' :
							state = 52;
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 55;
							break;
					}
					break;
				case  52 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case ' '  :
						case '\t' :
							i++;
							break;
						case EOS :
							state = 55;
							break;
						default  :
							state = 53;
							break;
					}
					break;
				case  53 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case ']' :
							state = 54;
							i++;
						case EOS :
							state = 55;
							break;
						default  :
							i++;
							break;
					}
					break;
				case  54 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						case EOS :
							state = 55;
							break;
						default  :
							state = 28;
							i++;
							break;
					}
					break;
				case  55 :
//System.out.println("MudPlayer.parse -- state "+state+" -- char = "+c);
					switch(c) {
						default  :
							done = true;
							break;
					}
					break;
				default :
					// should never get here...
					break;
			}
		}
		return(player);
	}

	public static void main(String args[]) {
		TinyMudParsePlayer	playerParser = null;
		MudPlayer		player       = null;
		String			aPlayer      = "nogard2000 is a bad little juvenile delinquent of a dragon who likes to run around questing and hang out in the town square people watching.\n[ Titles and Memberships: Brigand Lord/Lady, Enemies of the Silvan Elves, Prisoner of Love, Novice of the Blade, Preferred Player, DeepVisitors, sensual, Novice Musician, stargazers, Aefriti ]\nCarrying:\nDomestic Jopsy\nPetition\nThe Questers Rest Category Requirement List\nMap of the Guild of Musicians and Storyweavers\nButton: Be Naughty!!  Save Santa a Trip!\nA Map of the Ivory Tower\nA coil of rope\nA Map of London\n";


		playerParser = new TinyMudParsePlayer();
		player       = playerParser.parse(aPlayer);
	}
}
