/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
import java.io.*;
import java.util.*;
import util.*;
import mstar.*;

/**
  * Implements the TinyMud parser for the whereis command.
  *
  * @author Thaddeus O. Cooper (cooper@tweenproject.org)
  * @version 1.0
  */
public class TinyMudParseWhereis extends ParseWhereis {
	static final boolean debug = true;
	static final char    EOS   = '\0';

	Room parseRoomName(String s) {
		boolean	done = false;
		int	i    = 0;
		char	c;
		StringBuffer	roomNameStringBuffer    = null;
		StringBuffer	dbRefStringBuffer       = null;
		StringBuffer	descriptionStringBuffer = null;
		StringBuffer	commandsStringBuffer    = null;
		StringBuffer	exitsStringBuffer       = null;
		StringBuffer	contentsStringBuffer    = null;
		int		state                   = 1;
		Room		room                    = null;

		if ((s == null) ||
		    (s.length() == 0)) {
			done = true;
		}
		if (debug) {
			System.out.println("===> "+s);
			try{Thread.sleep(1000);}catch(InterruptedException ie){}
		}
		while (!done) {
			if (i < s.length()) {
					c = s.charAt(i);
			}
			else {
				c = EOS;
			}
			switch(state) {
				case  1 :
					if (roomNameStringBuffer == null) {
						roomNameStringBuffer = new StringBuffer();
					}
					switch (c) {
						case  '\n' :
							//i++;
							state = 4;
							break;
						case  '('  :
							i++;
							state = 2;
							break;
						case EOS   :
							state = 46;
							break;
						default    :
							roomNameStringBuffer.append(c);
							i++;
							break;
					}
					break;
				case  2 :
					if (dbRefStringBuffer == null) {
						dbRefStringBuffer = new StringBuffer();
					}
					switch (c) {
						case ')' :
							i++;
							state = 3;
							break;
						case EOS   :
							state = 46;
							break;
						default  :
							dbRefStringBuffer.append(c);
							i++;
							break;
					}
					break;
				case  3 :
					switch (c) {
						case '\n' :
							state = 4;
							break;
						case EOS   :
							state = 46;
							break;
						default   :
							i++;
							break;
					}
					break;
				case  4 :
					// we have a room name at the very least...
					if (room == null) {
						room = new Room();
						//room.setUsePossibleExits(getUsePossibleExits());
						//room.setUseFallbackExits(getUseFallbackExits());
						//room.setFallbackExits(getFallbackExits());
					}
					room.setName(roomNameStringBuffer.toString());
					if (dbRefStringBuffer != null) {
						room.setDBReference(dbRefStringBuffer.toString());
					}
					i++;
					state = 5;
					break;
				case  5 :
					if (descriptionStringBuffer == null) {
						descriptionStringBuffer = new StringBuffer();
					}
					switch (c) {
						case '['  :
							state = 6;
							break;
						case '\n' :
							i++;
							state = 6;
							break;
						case EOS   :
							state = 46;
							break;
						default   :
							//if (debug) {
							//	System.out.println(c);
							//}
							descriptionStringBuffer.append(c);
							if (debug) {
								//System.out.println(descriptionStringBuffer.toString());
							}
							i++;
							break;
					}
					break;
				case  6 :
					// we have the description...
System.out.println(descriptionStringBuffer.toString());
					room.setDescription(descriptionStringBuffer.toString());
					room.setPossibleExits(Utility.uniqueUniterms(descriptionStringBuffer.toString()));
					switch (c) {
						case '[' :
							i++;
							state = 7;
							break;
						case 'C' :
						case 'c' :
							i++;
							state = 30;
							break;
						case EOS :
							state = 43;
							break;
						default  :
//System.out.println("char was '"+c+"'");
							state = 51;
							break;
					}
					break;
				case  7 :
					switch (c) {
						case '\t' :
						case ' '  :
							i++;
							break;
						case 'C'  :
						case 'c'  :
							i++;
							state = 8;
							break;
						case 'E'  :
						case 'e'  :
							i++;
							state = 21;
							break;
						case EOS :
							state = 43;
							break;
						default    :
							state = 47;
							break;
					}
					break;
				case  8 :
					switch (c) {
						case 'O' :
						case 'o' :
							i++;
							state = 9;
							break;
						case EOS :
							state = 43;
							break;
						default   :
							state = 47;
							break;
					}
					break;
				case  9 :
					switch (c) {
						case 'M' :
						case 'm' :
							i++;
							state = 10;
							break;
						case EOS :
							state = 43;
							break;
						default   :
							state = 47;
							break;
					}
					break;
				case  10 :
					switch (c) {
						case 'M' :
						case 'm' :
							i++;
							state = 11;
							break;
						case EOS :
							state = 43;
							break;
						default   :
							state = 47;
							break;
					}
					break;
				case  11 :
					switch (c) {
						case 'A' :
						case 'a' :
							i++;
							state = 12;
							break;
						case EOS :
							state = 43;
							break;
						default   :
							state = 47;
							break;
					}
					break;
				case  12 :
					switch (c) {
						case 'N' :
						case 'n' :
							i++;
							state = 13;
							break;
						case EOS :
							state = 43;
							break;
						default   :
							state = 47;
							break;
					}
					break;
				case  13 :
					switch (c) {
						case 'D' :
						case 'd' :
							i++;
							state = 14;
							break;
						case EOS :
							state = 43;
							break;
						default   :
							state = 47;
							break;
					}
					break;
				case  14 :
					switch (c) {
						case 'S' :
						case 's' :
							i++;
							state = 15;
							break;
						case EOS :
							state = 43;
							break;
						default   :
							state = 47;
							break;
					}
					break;
				case  15 :
					switch (c) {
						case ':' :
							i++;
							state = 16;
							break;
						case EOS :
							state = 43;
							break;
						default   :
							state = 47;
							break;
					}
					break;
				case  16 :
					switch (c) {
						case '\t' :
						case ' '  :
							i++;
							break;
						case EOS  :
							state = 43;
							break;
						default   :
							state = 17;
							break;
					}
					break;
				case  17 :
					if (commandsStringBuffer == null) {
						commandsStringBuffer = new StringBuffer();
					}
					switch (c) {
						case ']' :
							i++;
							state = 18;
							break;
						case EOS  :
							state = 43;
							break;
						default  :
							commandsStringBuffer.append(c);
							i++;
							break;
					}
					break;
				case  18 :
					switch (c) {
						case '\n' :
							i++;
							state = 19;
							break;
						case EOS  :
							state = 44;
							break;
						default   :
							i++;
							break;
					}
					break;
				case  19 :
					// set the exits we know about...
					room.setCommands(Utility.commaListToArray(commandsStringBuffer.toString()));
					commandsStringBuffer.setLength(0);

					switch (c) {
						case '\t' :
						case ' '  :
							i++;
							break;
						case EOS  :
							state = 45;
							break;
						case '['  :
							i++;
							state = 20;
							break;
						case 'C'  :
						case 'c'  :
							i++;
							state = 30;
							break;
						default   :
							break;
					}
					break;
				case  20 :
					switch (c) {
						case '\t' :
						case ' '  :
							i++;
							break;
						case EOS  :
							state = 45;
							break;
						case 'E'  :
						case 'e'  :
							i++;
							state = 21;
							break;
						default   :
							state = 47;
							break;
					}
					break;
				case  21 :
					switch (c) {
						case 'X'  :
						case 'x'  :
							i++;
							state = 22;
							break;
						case EOS  :
							state = 45;
							break;
						default   :
							state = 47;
							break;
					}
					break;
				case  22 :
					switch (c) {
						case 'I'  :
						case 'i'  :
							i++;
							state = 23;
							break;
						case EOS  :
							state = 45;
							break;
						default   :
							state = 47;
							break;
					}
					break;
				case  23 :
					switch (c) {
						case 'T'  :
						case 't'  :
							i++;
							state = 24;
							break;
						case EOS  :
							state = 45;
							break;
						default   :
							state = 47;
							break;
					}
					break;
				case  24 :
					switch (c) {
						case 'S'  :
						case 's'  :
							i++;
							state = 25;
							break;
						case EOS  :
							state = 45;
							break;
						default   :
							state = 47;
							break;
					}
					break;
				case  25 :
					switch (c) {
						case ':'  :
							i++;
							state = 26;
							break;
						case EOS  :
							state = 45;
							break;
						default   :
							state = 47;
							break;
					}
					break;
				case  26 :
					switch (c) {
						case '\t' :
						case ' '  :
							i++;
							break;
						case EOS  :
							state = 45;
							break;
						default   :
							state = 27;
							break;
					}
					break;
				case  27 :
					if (exitsStringBuffer == null) {
						exitsStringBuffer = new StringBuffer();
					}
					switch (c) {
						case ']' :
							i++;
							state = 28;
							break;
						case EOS :
							state = 45;
							break;
						default  :
							exitsStringBuffer.append(c);
							i++;
							break;
					}
					break;
				case  28 :
					switch (c) {
						case '\n' :
							i++;
							state = 29;
							break;
						case EOS  :
							state = 45;
							break;
						default   :
							i++;
							break;
					}
					break;
				case  29 :
					// set the exits we know about...
					room.setShownExits(Utility.commaListToArray(exitsStringBuffer.toString()));
					for (int j = 0; j < room.getShownExits().length; j++) {
						System.out.println((room.getShownExits())[j]);
					}
					exitsStringBuffer.setLength(0);
					for (int j = 0; j < room.getShownExits().length; j++) {
						System.out.println((room.getShownExits())[j]);
					}

					switch (c) {
						case 'C' :
						case 'c' :
							i++;
							state = 30;
							break;
						case EOS :
							state = 41;
							break;
						default  :
							state = 42;
							break;
					}
					break;
				case  30 :
					switch (c) {
						case 'O' :
						case 'o' :
							i++;
							state = 31;
							break;
						case EOS :
							state = 41;
							break;
						default  :
							state = 42;
							break;
					}
					break;
				case  31 :
					switch (c) {
						case 'N' :
						case 'n' :
							i++;
							state = 32;
							break;
						case EOS :
							state = 41;
							break;
						default  :
							state = 42;
							break;
					}
					break;
				case  32 :
					switch (c) {
						case 'T' :
						case 't' :
							i++;
							state = 33;
							break;
						case EOS :
							state = 41;
							break;
						default  :
							state = 42;
							break;
					}
					break;
				case  33 :
					switch (c) {
						case 'E' :
						case 'e' :
							i++;
							state = 34;
							break;
						case EOS :
							state = 41;
							break;
						default  :
							state = 42;
							break;
					}
					break;
				case  34 :
					switch (c) {
						case 'N' :
						case 'n' :
							i++;
							state = 35;
							break;
						case EOS :
							state = 41;
							break;
						default  :
							state = 42;
							break;
					}
					break;
				case  35 :
					switch (c) {
						case 'T' :
						case 't' :
							i++;
							state = 36;
							break;
						case EOS :
							state = 41;
							break;
						default  :
							state = 42;
							break;
					}
					break;
				case  36 :
					switch (c) {
						case 'S' :
						case 's' :
							i++;
							state = 37;
							break;
						case EOS :
							state = 41;
							break;
						default  :
							state = 42;
							break;
					}
					break;
				case  37 :
					switch (c) {
						case ':' :
							i++;
							state = 38;
							break;
						case EOS :
							state = 41;
							break;
						default  :
							state = 42;
							break;
					}
					break;
				case  38 :
					switch (c) {
						case '\n' :
							i++;
							state = 39;
							break;
						case EOS :
							state = 41;
							break;
						default   :
							i++;
					}
					break;
				case  39 :
					switch (c) {
						case EOS :
							//room.addContents(contentsStringBuffer.toString());
							//contentsStringBuffer.setLength(0);
							state = 40;
							break;
						case '\n' :
							room.addContents(contentsStringBuffer.toString());
							contentsStringBuffer.setLength(0);
							i++;
							break;
						default   :
							if (contentsStringBuffer == null) {
								contentsStringBuffer = new StringBuffer();
							}
							contentsStringBuffer.append(c);
							i++;
							break;
					}
					break;
				case  40 :
					done = true;
					break;
				case  41 :
					done = true;
					break;
				case  42 :
					done = true;
					break;
				case  43 :
					done = true;
					break;
				case  44 :
					done = true;
					break;
				case  45 :
					done = true;
					break;
				case  46 :
					done = true;
					break;
				case  47 :
					done = true;
					break;
				case  48 :
					switch (c) {
						case  'O' :
						case  'o' :
							i++;
							state = 49;
							break;
						default  :
							break;
					}
					break;
				case  49 :
					switch (c) {
						case 'U' :
						case 'u' :
							i++;
							state = 50;
							break;
						default  :
							break;
					}
					break;
				case  50 :
					switch (c) {
						case  '\n' :
							i++;
							state = 1;
							break;
						default  :
							i++;
							break;
					}
					break;
				case  51 :
					switch (c) {
						case  '[' :
							state = 6;
							break;
						case   EOS :
							done = true;
							break;
						default  :
							i++;
							break;
					}
					break;
				default :
					// should never get here...
					break;
			}
		}
		return(room);
	}

	/**
	  */
	public Room parse(String s) {
		boolean	done = false;
		int	i    = 0;
		char	c;
		int	state = 0;
		StringBuffer	roomInformation = null;
		Room		theRoom         = null;

		if ((s == null) || (s.length() == 0)) {
			done = true;
		}
		if (debug) {
			System.out.println("===> "+s);
			try{Thread.sleep(1000);}catch(InterruptedException ie){}
		}
		while (!done) {
			if (i < s.length()) {
				c = s.charAt(i);
			}
			else {
				c = EOS;
			}
			switch (state) {
				case  0 :
					switch (c) {
						case 'L' :
						case 'l' :
							i++;
							state = 1;
							break;
						default  :
							state = 12;
							break;
					}
					break;
				case  1 :
					switch (c) {
						case 'O' :
						case 'o' :
							i++;
							state = 2;
							break;
						default  :
							state = 12;
							break;
					}
					break;
				case  2 :
					switch (c) {
						case 'C' :
						case 'c' :
							i++;
							state = 3;
							break;
						default  :
							state = 12;
							break;
					}
					break;
				case  3 :
					switch (c) {
						case 'A' :
						case 'a' :
							i++;
							state = 4;
							break;
						default  :
							state = 12;
							break;
					}
					break;
				case  4 :
					switch (c) {
						case 'T' :
						case 't' :
							i++;
							state = 5;
							break;
						default  :
							state = 12;
							break;
					}
					break;
				case  5 :
					switch (c) {
						case 'I' :
						case 'i' :
							i++;
							state = 6;
							break;
						default  :
							state = 12;
							break;
					}
					break;
				case  6 :
					switch (c) {
						case 'O' :
						case 'o' :
							i++;
							state = 7;
							break;
						default  :
							state = 12;
							break;
					}
					break;
				case  7 :
					switch (c) {
						case 'N' :
						case 'n' :
							i++;
							state = 8;
							break;
						default  :
							state = 12;
							break;
					}
					break;
				case  8 :
					switch (c) {
						case ':' :
							i++;
							state = 9;
							break;
						default  :
							state = 12;
							break;
					}
					break;
				case  9 :
					switch (c) {
						case ' ' :
							i++;
							state = 10;
							break;
						default  :
							state = 12;
							break;
					}
					break;
				case 10 :
					switch (c) {
						case EOS :
							state = 11;
							break;
						default  :
							if (roomInformation == null) {
								roomInformation = new StringBuffer();
							}
							roomInformation.append(c);
							i++;
							break;
					}
					break;
				case 11 :
					theRoom = parseRoomName(roomInformation.toString());
					done    = true;
					break;
				case 12 :
					done    = true;
					break;
				default :
					// should never get here...
			}
		}
		return(theRoom);
	}
}
