/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
import gnu.regexp.*;
import java.util.*;
import util.*;
import mstar.*;

/**
  * Responds to arrival events.
  *
  * @author Thaddeus O. Cooper (cooper@tweenproject.org)
  * @version 1.1
  */
public class ArrivalResponder extends Responder {
	String	helloResponses[] = {
					"Hello ",
					"Hola! ",
					"Howdy ",
					"Hello ",
					"Hi ",
					null,
					"Greetings ",
					"Greetings and salutations ",
					"Howdy do ",
					"How do ",
				   };

	String helloActions[] = {
					"Bows to ",
					"Curtsies to ",
					null,
					"Waves to ",
					"Jumps up and down in from of ",
					"Hugs ",
					"Huggles ",
					"Embraces ",
				};

	public void process() {
		String	response = null;
		String	action   = null;

		response = helloResponses[(int)(Math.random()*9.99)];
		action   = helloActions[(int)(Math.random()*7.99)];
		if (response != null) {
			addResponse(response+getWho());
		}
		if (action != null) {
			addAction("pose", action+getWho());
		}
	}

	public String serviceType() {
		return("ONARRIVAL");
	}

	public boolean canProcess(Chatter c) {
		boolean	rc = false;

		if (c.getHow() == Chatter.ARRIVES) {
			rc = true;
		}
		return(rc);
	}
}
