/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
import gnu.regexp.*;
import java.util.*;
import util.*;
import mstar.*;

/**
  * Responds to questions about how to get to places in the collaborative
  * environment. If asked how to get to Carnegie Hall, it will respond
  * &quot;Practice!&quot;
  *
  * @author Thaddeus O. Cooper
  * @version 1.1
  */
public class DirectionsResponder extends Responder {
	String	where = null;
	Chatter	c     = null;

	void setWhere(String where) {
		this.where = where;
	}

	protected String getWhere() {
		return(this.where);
	}

	protected boolean getDirections(String where) {
		Room	theRoom = null;
		Stack	s       = null;
		Stack	dirs    = null;
		boolean	rc      = false;

		if (!where.equals("carnegie hall")) {
			if (getMap() != null) {
				theRoom = getMap().getRoom(getWhere());
				if (theRoom != null) {
					getMap().clearRoomsVisited();
					s = getMap().findPath(0, theRoom.getId());
					if ((s != null) && (!s.empty())) {
						dirs = new Stack();
						while (!s.empty()) {
							dirs.push(s.pop());
						}
						addResponse(getMap().makeDirections(0, dirs));
						rc = true;
					}
				}
			}
		}
		else {
			rc = true;
			addResponse("Practice!");
			addAction("pose", "sits down at an imaginary piano and starts to play.");
		}
		return(rc);
	}

	public void process() {
		if (!getDirections(getWhere())) {
			addResponse("I don't know how to get to "+getWhere()+".");
		}
	}

	public String serviceType() {
		return("DIRECTIONS");
	}

	public boolean canProcess(Chatter c) {
		boolean	rc  = false;
		RE	re  = null;
		REMatch	rem = null;

		try {
			re = new RE(".*how do i get to (.*)");
			if (c.getWhat() != null) {
				rc = re.isMatch(c.getWhat().toLowerCase());
			}
			if (rc) {
				rem = re.getMatch(c.getWhat().toLowerCase());
				setWhere(Utility.removePunctuation(c.getWhat().substring(rem.getSubStartIndex(1)).trim()).trim());
				this.c = c;
			}
		}
		catch(REException ree) {
			rc = false;
		}
		return(rc);
	}
}
