/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
import gnu.regexp.*;
import java.util.*;
import java.io.*;
import util.*;
import mstar.*;

/**
  * Responds to pages from players in the collaborative environment to come to
  * a specific room. If the room is in the robot's map then it will attempt to
  * go to the room.
  *
  * @author Thaddeus O. Cooper (cooper@tweenproject.org)
  * @version 1.1
  */
public class GoToResponder extends Responder {
	String	place = null;
	String	theLine = null;
	Chatter	c       = null;

	/**
	  */
	StringBuffer getRoomDescription() {
		StringBuffer	rd = null;
		String		aLine = null;

		try {
			getConnection().waitForData();
			aLine = getConnection().readLine();
			if (rd == null) {
				rd = new StringBuffer();
			}
			while (!aLine.startsWith(getConnection().getOutputSuffix())) {
				rd.append(aLine+"\n");
				aLine = getConnection().readLine();
			}
		}
		catch(IOException ioe) {
		}
		return(rd);
	}

	Room lookHere() {
		StringBuffer	rd = null;
		Room		room = null;

		getCommands().look("");
		getConnection().findOutputPrefix();
		rd = getRoomDescription();
		if (rd != null) {
			room = getRoomParser().parse(rd.toString());
		}
		return(room);
	}

	public void process() {
		Stack	directions = null;
		Exit	theExit    = null;
		Room	here       = null;
		Room	there      = null;
		boolean	rc = false;
		RE	re  = null;
		REMatch	rem = null;

		place = c.getWhat();
		if (place != null) {
			if (place.endsWith(".")) {
				place = place.substring(0, place.length()-1);
				if (place.length() > 0) {
					here = lookHere();
					here = getMap().getRoom(here);
					if (here != null) {
						there = getMap().getRoom(place);
						directions = getMap().findPathToRoom(here, there);
						if ((directions != null)  && (!directions.empty())) {
							while ((directions != null) && (!directions.empty())) {
								theExit = ((Exit)directions.pop());
								addRobotAction("GO", theExit.getDirection());
							}
							addResponse("I was paged here by "+getWho());
						}
					}
				}
			}
		}
	}

	public String serviceType() {
		return("GOTO");
	}

	public boolean canProcess(Chatter c) {
		boolean	rc = false;

		this.c = c;
		rc = (c.getHow() == Chatter.PAGED_TO);
		return(rc);
	}
}
