/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
import gnu.regexp.*;
import java.util.*;
import util.*;
import mstar.*;

/**
  * Responds to requests for the location of objects within the collaborative
  * environment. If asked &quot;Where is Carnegie Hall?&quot; then it will
  * tell the character, &quot;New York City&quot; and do a little shuffle.
  *
  * @author Thaddeus O. Cooper (cooper@tweenproject.org)
  * @version 1.1
  */
public class LocatorResponder extends DirectionsResponder {
	private boolean findObject() {
		boolean		rc      = false;
		Vector		rooms   = null;
		StringBuffer	resp    = null;
		int		i       = 0;
		int		length  = 0;

		if (!getWhere().toLowerCase().startsWith("carnegie hall")) {
			rc = getDirections(Utility.removePunctuation(getWhere()));
			if (!rc) {
				// couldn't find a room with that name, so try an
				// object for that name...
				if (getMap() != null) {
					rooms = getMap().findObject(getWhere());
					if (rooms != null) {
						rc   = true;
						resp = new StringBuffer();
						resp.append("There is a ").append(getWhere()).append(" in ");
						length = rooms.size();
						for (i = 0; i < length; i++) {
							if (i != 0) {
								resp.append(", and in ");
							}
							resp.append(((Room)rooms.elementAt(i)).getName());
						}
						addResponse(resp.toString());
					}
					else {
						addResponse("I don't know where "                 +
							    Utility.removePunctuation(getWhere()) +
							    " is, you might try asking Newt.");
					}
				}
				else {
					addAction("pose", "scratches his head");
					addResponse("I seem to have lost my map");
				}
			}
			else {
				addResponse("I don't know where "                 +
					    Utility.removePunctuation(getWhere()) +
					    " is, you might try asking Newt.");
			}
		}
		else {
			addResponse("New York City!");
			addAction("pose", "starts doing the New York Shuffle while singing...");
			addResponse("I love New York -- hmmm hmmmm hmmm hmmm");
		}
		return(rc);
	}

	public void process() {
		findObject();
	}

	public String serviceType() {
		return("LOCATOR");
	}

	public boolean canProcess(Chatter c) {
		boolean	rc  = false;
		RE	re  = null;
		REMatch	rem = null;

		try {
			re = new RE("where is (.*)");
			if (c.getWhat() != null) {
				rc = re.isMatch(c.getWhat().toLowerCase());
			}
			if (rc) {
				rem = re.getMatch(c.getWhat().toLowerCase());
				setWhere(c.getWhat().substring(rem.getSubStartIndex(1)));
			}
		}
		catch(REException ree) {
			rc = false;
		}
		return(rc);
	}
}
