/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
import gnu.regexp.*;
import java.util.*;
import util.*;
import mstar.*;

/**
  * Responds to questions about Isaac Asimov's three laws of robotics.
  *
  * @author Thaddeus O. Cooper (cooper@tweenproject.org)
  * @version 1.1
  */
public class ThreeLawsResponder extends Responder {
	public void process() {
		addResponse("1. A Robot may not injure a human being, or, through inaction, allow a human being to come to harm.");
		addResponse("2. A robot must obey the orders given it by human beings except where such orders would conflict with the First Law.");
		addResponse("3. A robot must protect its own existence as long as such protection does not conflict with the First and Second Laws.");
		addResponse("--Isaac Asimov, \"Runaround\", Astounding Science Fiction, March 1942.");
	}

	public String serviceType() {
		return("ROBOT INFORMATION");
	}

	public boolean canProcess(Chatter c) {
		boolean	rc = false;

		if (c.getWhat() != null) {
			try {
				rc = new RE(".*what are .*(3|three).*laws .*").isMatch(c.getWhat().toLowerCase());
			}
			catch(REException ree) {
				rc = false;
			}
		}
		return(rc);
	}
}
