/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
import java.io.*;
import java.util.*;
import os.*;
import mstar.*;
import org.place.pj.*;

/**
  * A Bot OS program to set the description of an object in the collaborative
  * environment.
  *
  * @author Thaddeus O. Cooper (cooper@tweenproject.org)
  * @version 1.0
  */
public class Describe extends OSProcess {
	static final String	DEFAULT_ROBOT_PROPERTIES_FILENAME="robot.properties";
	int		state = 0;
	DataInputStream	in    = null;
	FileInputStream propertiesIn = null;
	PrintStream	out   = null;
	Connection	mudConnection = null;
	Commands	commands   = null;
	Properties	properties = null;
	String		robotDescription = null;
	boolean		verbose	      = true;	/* if set to true the bot */
						/* prints a lot of        */
						/* information to stdout. */
	String		outputPrefix  = null;
	String		outputSuffix  = null;

	public void initialize() {
		String		portString = null;
		String[]	args = null;
		Commandline	cl = null;
		Properties	properties = null;
		String		longOptions[] = {
							"properties",
						};
		String		longFlags[] = {
						"verbose",
					      };

		if (args == null) {
			args = getArgs();
			try {
				cl = new Commandline(args,
					     	"nPmv",
					     	"",
					     	longFlags,
					     	longOptions);
				// first things first, see if there is a
				// properties file that was specified
				if (cl.hasOption("properties")) {
					try {
						propertiesIn = new FileInputStream(cl.getOption("properties"));
						properties = new Properties();
						properties.load(propertiesIn);
					}
					catch (IOException ioe) {
						System.out.println("Properties file '"+
							   	cl.getOption("properties")+
							   	"' not found.");
						System.exit(-1);
					}
				}
				else {
					try {
						// first look in the local directory...
						propertiesIn = new FileInputStream(System.getProperty("user.dir")+
								 	File.separator+DEFAULT_ROBOT_PROPERTIES_FILENAME);
						properties = new Properties();
						properties.load(propertiesIn);
					}
					catch (IOException ioe) {
						try {
							// now try the home directory....
							propertiesIn = new FileInputStream(System.getProperty("user.home")+
									 	File.separator+DEFAULT_ROBOT_PROPERTIES_FILENAME);
							properties = new Properties();
							properties.load(propertiesIn);
						}
						catch (IOException ioe1) {
						}
					}
				}
				if (properties != null) {
					verbose = properties.getProperty("robot.verbose", "false").toLowerCase().equals("true") ? true : false;	
					robotDescription = properties.getProperty("robot.description");
				}
	
				if (cl.hasOption("v")) {
					verbose = true;
				}
				if (cl.hasOption("verbose")) {
					verbose = true;
				}
	
				if (verbose) {
					if (robotDescription != null) {
						System.out.println("description: "+robotDescription);
					}
					else {
						System.out.println("description: null");
					}
				}
	
			}
			catch (InvalidCommandlineArgument ica) {
				System.out.println("invalid command line argument "+ica.toString());
			}
		}
		if (mudConnection == null) {
			mudConnection = (Connection)requestObject("RobotConnection");
		}
		if (commands == null) {
			commands = (Commands)requestObject("RobotCommands");
		}
		if ((mudConnection != null) && (commands != null)) {
			setInitialized(true);
		}
	}


	public void run() throws OSProcessDone {
		commands.describe(robotDescription);
		mudConnection.drainConnectionToSuffix();
		throw new OSProcessDone();
	}

}
