/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
import java.io.*;
import java.util.*;
import os.*;
import mstar.*;
import org.place.pj.*;

/**
  * A Bot OS program to echo a string to stdout while the robot is running.
  *
  * @author Thaddeus O. Cooper (cooper@tweenproject.org)
  * @version 1.0
  */
public class Echo extends OSProcess {
	int		state         = 0;
	String[]	args          = null;
	boolean		nocr          = false;

	public void initialize() {
		Commandline	cl = null;
		Properties	properties = null;
		String		longOptions[] = {
						};
		String		longFlags[] = {
						"nocr",
					      };

		if (args == null) {
			args = getArgs();
			try {
				cl = new Commandline(args,
					     	"n",
					     	"",
					     	longFlags,
					     	longOptions);
				if (cl.hasOption("n")) {
					nocr = true;
				}
				if (cl.hasOption("nocr")) {
					nocr = true;
				}
			}
			catch (InvalidCommandlineArgument ica) {
				System.out.println("invalid command line argument "+ica.toString());
			}
		}
		setInitialized(true);
	}

	public void run() throws OSProcessDone {
		if (nocr) {
			System.out.print(args[2]);
		}
		else {
			System.out.println(args[1]);
		}
		throw new OSProcessDone();
	}
}
