/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
import java.io.*;
import java.util.*;
import os.*;
import mstar.*;
import org.place.pj.*;

/**
  * A Bot OS program for loading the appropriate room description parser for 
  * the collaborative environment that the robot is running in.
  *
  * @author Thaddeus O. Cooper (cooper@tweenproject.org)
  * @version 1.0
  */
public class LoadRoomDescriptionParser extends OSProcess {
	static final String	DEFAULT_ROBOT_PROPERTIES_FILENAME = "robot.properties";
	int		state = 0;
	DataInputStream	in    = null;
	FileInputStream	propertiesIn    = null;
	PrintStream	out   = null;
	String		mudType       = null;
	boolean		verbose	      = true;	/* if set to true the bot */
						/* prints a lot of        */
						/* information to stdout. */

	public void initialize() {
		String[]	args = null;
		Commandline	cl = null;
		Properties	properties = null;
		String		longOptions[] = {
							"properties",
							"mudtype",
						};
		String		longFlags[] = {
						"verbose",
					      };

		args = getArgs();
		try {
			cl = new Commandline(args,
					     "pmv",
					     "",
					     longFlags,
					     longOptions);
			// first things first, see if there is a
			// properties file that was specified
			if (cl.hasOption("properties")) {
				try {
					propertiesIn = new FileInputStream(cl.getOption("properties"));
					properties = new Properties();
					properties.load(propertiesIn);
				}
				catch (IOException ioe) {
					System.out.println("Properties file '"+
							   cl.getOption("properties")+
							   "' not found.");
					System.exit(-1);
				}
			}
			else {
				try {
					// first look in the local directory...
					propertiesIn = new FileInputStream(System.getProperty("user.dir")+
								 File.separator+DEFAULT_ROBOT_PROPERTIES_FILENAME);
					properties = new Properties();
					properties.load(propertiesIn);
				}
				catch (IOException ioe) {
					try {
						// now try the home directory....
						propertiesIn = new FileInputStream(System.getProperty("user.home")+
									 File.separator+DEFAULT_ROBOT_PROPERTIES_FILENAME);
						properties = new Properties();
						properties.load(propertiesIn);
					}
					catch (IOException ioe1) {
					}
				}
			}
			if (properties != null) {
				verbose = properties.getProperty("robot.verbose", "false").toLowerCase().equals("true") ? true : false;	
				mudType = properties.getProperty("robot.mudType");
			}

			if (cl.hasOption("v")) {
				verbose = true;
			}
			if (cl.hasOption("verbose")) {
				verbose = true;
			}
			if (cl.hasOption("m")) {
				mudType = cl.getOption("m");
			}
			if (cl.hasOption("mudtype")) {
				mudType = cl.getOption("mudtype");
			}

			if (verbose) {
				if (mudType != null) {
					System.out.println("mudType: "+mudType);
				}
				else {
					System.out.println("mudType: null");
				}
			}

		}
		catch (InvalidCommandlineArgument ica) {
			System.out.println("invalid command line argument "+ica.toString());
		}
		setInitialized(true);
	}

	public String getMudType() {
		return(this.mudType);
	}


	ParseRoomDescription loadRoomDescriptionParser(String mudType) {
		RoomDescriptionParserClassLoader	loader         = null;
		String				className      = null;
		Class				c              = null;
		Object				o              = null;
		StringBuffer			parsersPath   = null;
		ParseRoomDescription		parser         = null;

		try {
			parsersPath = new StringBuffer();
			parsersPath.append("plugins").append(File.separator).append("parsers");
			loader = new RoomDescriptionParserClassLoader(parsersPath.toString());
			className = mudType + "ParseRoomDescription";
			System.out.println(className);
			c = loader.loadClass(className, true);
			o = c.newInstance();
			parser = (ParseRoomDescription)o;
		}
		catch(ClassNotFoundException cnfe) {
			System.out.println(cnfe.toString());
		}
		catch(IllegalAccessException iae) {
			System.out.println(iae.toString());
		}
		catch(InstantiationException ie) {
			System.out.println(ie.toString());
		}
		return(parser);
	}

	public void run() throws OSProcessDone {
		ParseRoomDescription	parser   = null;

		parser = loadRoomDescriptionParser(getMudType());
		registerObject("RoomDescriptionParser", parser);
		throw new OSProcessDone();
	}
}
