/*
 *
 * Copyright (c) 1999, 2000 Thaddeus O. Cooper
 * 
 *          Permission is hereby granted, free of charge, to any person 
 *          obtaining a copy of this software and associated documentation
 *          files (the "Software"), to deal in the Software without 
 *          restriction, including without limitation the rights to use, copy,
 *          modify, merge, publish, distribute, sublicense, and/or sell copies 
 *          of the Software, and to permit persons to whom the Software is 
 *          furnished to do so, subject to the following conditions:
 *
 *          The above copyright notice and this permission notice shall be 
 *          included in all copies or substantial portions of the Software.
 *
 *         THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *         EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 *         MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *         NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
 *         BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
 *         ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 *         CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 *         SOFTWARE.
 *
 */
package util;

import java.util.*;

public class Utility {
	static final char EOS = '\0';

	/**
	  *  This routine takes a comma delimited string and breaks
	  *  it apart into an array.
	  *
	  *  @param  l -- the string to be broken apart
	  *  @return String[]
	  */
	public static String[] commaListToArray(String l) {
		int		state = 0;
		boolean		done  = false;
		int		i     = 0;
		char		c;
		Vector		v     = null;
		String[]	ary   = null;
		StringBuffer	sb    = null;
		int		length;

		length = l.length();
		while (!done) {
			if (i < length) {
				c = l.charAt(i);
			}
			else {
				c = EOS;
			}
			switch (state) {
				case 0  :
					// remove leading white space
					if ((c != ' ') &&
					    (c != '\n') &&
					    (c != '\t')) {
						state = 1;
					}
					else if (c == EOS) {
						state = 3;
					}
					else {
						i++;
					}
					break;
				case 1  :
					// parse until comma or end of string
					if (c == EOS) {
						state = 3;
					}
					else if (c != ',') {
						if (sb == null) {
							sb = new StringBuffer();
						}
						sb.append(c);
						i++;
					}
					else {
						state = 2;
					}
					break;
				case 2  :
					// put the string into the vector
					if (v == null) {
						v = new Vector();
					}
					v.addElement(sb.toString());
					sb.setLength(0);
					i++;
					state = 0;
					break;
				case 3  :
					// add the last element...
					if (sb != null) {
						if (v == null) {
							v = new Vector();
						}
						v.addElement(sb.toString());
						ary = new String[v.size()];
						v.copyInto(ary);
					}
					done = true;
					break;
				default :
					// should never get here...
					break;
			}
		}
		return(ary);
	}

	/**
	  *  This routine wrap each element in an array with a
	  *  prefix string and a suffix string.
	  */
	public static String[] wrap(String ary[], 
				    String prefix, 
				    String suffix) {
		String	newAry[] = null;
		int	i;
		int	length;

		length = ary.length;
		newAry = new String[length];

		for (i = 0; i < length; i++) {
			newAry[i] = prefix+ary[i]+suffix;
		}
		return(newAry);
	}

	/**
	  *  This routine joins the elements of an array and returns
	  *  them as a string.
	  *
	  *  @param ary     -- the array to be joined.
	  *  @param joiner  -- the string used to join each element
	  *  @return String -- the joined string
	  */
	public static String join(String ary[], String joiner) {
		int		length;
		StringBuffer	sb = null;
		int		i;

		sb = new StringBuffer();
		length = ary.length;
		for (i = 0; i < (length - 1); i++) {
			sb.append(ary[i]).append(joiner);
		}
		sb.append(ary[i]);
		return(sb.toString());
	}

	public static String removePunctuation(String s) {
		boolean	somethingChanged = true;

		while ((somethingChanged) && (s.length() > 0)) {
			somethingChanged = false;
			if (s.endsWith("\"") ||
			    s.endsWith(",") ||
			    s.endsWith("!") ||
			    s.endsWith("?") ||
			    s.endsWith(";") ||
			    s.endsWith(")") ||
			    s.endsWith("}") ||
			    s.endsWith("]") ||
			    s.endsWith(".")) {
				s = s.substring(0, s.length()-1);
				somethingChanged = true;
			}
		}
		if (s.startsWith("\"") ||
		    s.startsWith("'")) {
			s = s.substring(1);
		}
		return(s);
	}

	public static void removePunctuation(String s[]) {
		int	i;
		int	length;

		length = s.length;
		for (i = 0; i < length; i++) {
			s[i] = removePunctuation(s[i]);
		}
	}

	public static String[] stringToUniterms(String s) {
		StringTokenizer	st     = null;
		String		aToken = null;
		Vector		v      = null;
		String		ary[]  = null;

		st = new StringTokenizer(s);
		v  = new Vector();
		while (st.hasMoreTokens()) {
			aToken = st.nextToken();
			v.addElement(aToken);
		}
		ary = new String[v.size()];
		v.copyInto(ary);
		return(ary);
	}

	public static String[] uniqueUniterms(String s) {
		String	ary[] = null;

		ary = Utility.stringToUniterms(s);
		removePunctuation(ary);
		toLowerCase(ary);
		Arrays.sort(ary, new SortableString());
		ary = Utility.unique(ary);

		return(ary);
	}

	public static void toLowerCase(String s[]) {
		int	i;
		int	length;

		length = s.length;
		for (i = 0; i < length; i++) {
			s[i] = s[i].toLowerCase();
		}
	}

	public static String[] unique(String s[]) {
		int	i;
		int	length;
		String	lastWord = "";
		Vector	v        = null;
		String	ary[]    = null;
		
		v = new Vector();
		length = s.length;
		for (i = 0; i < length; i++) {
			if (!lastWord.equals(s[i])) {
				v.addElement(s[i]);
				lastWord = s[i];
			}
		}
		ary = new String[v.size()];
		v.copyInto(ary);
		return(ary);
	}

	/**
	  */
	public static String formatNumber(int n) {
		String rc = "";

		if (n < 10) {
			rc = "0"+Integer.toString(n);
		}
		else {
			rc = Integer.toString(n);
		}
		return(rc);
	}

	/**
	  */
	public static String getMonth(int m) {
		String months[] = {
					"Jan",
					"Feb",
					"Mar",
					"Apr",
					"May",
					"Jun",
					"Jul",
					"Aug",
					"Sep",
					"Oct",
					"Nov",
					"Dec",
				  };
		return(months[m]);
	}
}
